/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.inbound;

import java.util.concurrent.TimeUnit;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandlerContext;
import org.neo4j.driver.internal.shaded.io.netty.handler.timeout.ReadTimeoutHandler;
import org.neo4j.driver.v1.exceptions.ServiceUnavailableException;

public class ConnectTimeoutHandler
extends ReadTimeoutHandler {
    private final long timeoutMillis;
    private boolean triggered;

    public ConnectTimeoutHandler(long timeoutMillis) {
        super(timeoutMillis, TimeUnit.MILLISECONDS);
        this.timeoutMillis = timeoutMillis;
    }

    @Override
    protected void readTimedOut(ChannelHandlerContext ctx) {
        if (!this.triggered) {
            this.triggered = true;
            ctx.fireExceptionCaught(this.unableToConnectError());
        }
    }

    private ServiceUnavailableException unableToConnectError() {
        return new ServiceUnavailableException("Unable to establish connection in " + this.timeoutMillis + "ms");
    }
}

