/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.security;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Security;
import java.security.cert.CertSelector;
import java.security.cert.CertificateException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.neo4j.driver.internal.RevocationStrategy;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.internal.util.CertificateTool;

public class SecurityPlanImpl
implements SecurityPlan {
    private final boolean requiresEncryption;
    private final SSLContext sslContext;
    private final boolean requiresHostnameVerification;
    private final RevocationStrategy revocationStrategy;

    public static SecurityPlan forAllCertificates(boolean requiresHostnameVerification, RevocationStrategy revocationStrategy) throws GeneralSecurityException {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(new KeyManager[0], new TrustManager[]{new TrustAllTrustManager()}, null);
        return new SecurityPlanImpl(true, sslContext, requiresHostnameVerification, revocationStrategy);
    }

    public static SecurityPlan forCustomCASignedCertificates(File certFile, boolean requiresHostnameVerification, RevocationStrategy revocationStrategy) throws GeneralSecurityException, IOException {
        SSLContext sslContext = SecurityPlanImpl.configureSSLContext(certFile, revocationStrategy);
        return new SecurityPlanImpl(true, sslContext, requiresHostnameVerification, revocationStrategy);
    }

    public static SecurityPlan forSystemCASignedCertificates(boolean requiresHostnameVerification, RevocationStrategy revocationStrategy) throws GeneralSecurityException, IOException {
        SSLContext sslContext = SecurityPlanImpl.configureSSLContext(null, revocationStrategy);
        return new SecurityPlanImpl(true, sslContext, requiresHostnameVerification, revocationStrategy);
    }

    private static SSLContext configureSSLContext(File customCertFile, RevocationStrategy revocationStrategy) throws GeneralSecurityException, IOException {
        KeyStore trustedKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        trustedKeyStore.load(null, null);
        if (customCertFile != null) {
            CertificateTool.loadX509Cert(customCertFile, trustedKeyStore);
        } else {
            SecurityPlanImpl.loadSystemCertificates(trustedKeyStore);
        }
        PKIXBuilderParameters pkixBuilderParameters = new PKIXBuilderParameters(trustedKeyStore, (CertSelector)new X509CertSelector());
        pkixBuilderParameters.setRevocationEnabled(RevocationStrategy.requiresRevocationChecking(revocationStrategy));
        if (RevocationStrategy.requiresRevocationChecking(revocationStrategy)) {
            System.setProperty("jdk.tls.client.enableStatusRequestExtension", "true");
            if (revocationStrategy.equals((Object)RevocationStrategy.VERIFY_IF_PRESENT)) {
                Security.setProperty("ocsp.enable", "true");
            }
        }
        SSLContext sslContext = SSLContext.getInstance("TLS");
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(new CertPathTrustManagerParameters(pkixBuilderParameters));
        sslContext.init(new KeyManager[0], trustManagerFactory.getTrustManagers(), null);
        return sslContext;
    }

    private static void loadSystemCertificates(KeyStore trustedKeyStore) throws GeneralSecurityException, IOException {
        TrustManagerFactory tempFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tempFactory.init((KeyStore)null);
        X509TrustManager x509TrustManager = null;
        for (TrustManager trustManager : tempFactory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            x509TrustManager = (X509TrustManager)trustManager;
            break;
        }
        if (x509TrustManager == null) {
            throw new CertificateException("No system certificates found");
        }
        CertificateTool.loadX509Cert(x509TrustManager.getAcceptedIssuers(), trustedKeyStore);
    }

    public static SecurityPlan insecure() {
        return new SecurityPlanImpl(false, null, false, RevocationStrategy.NO_CHECKS);
    }

    private SecurityPlanImpl(boolean requiresEncryption, SSLContext sslContext, boolean requiresHostnameVerification, RevocationStrategy revocationStrategy) {
        this.requiresEncryption = requiresEncryption;
        this.sslContext = sslContext;
        this.requiresHostnameVerification = requiresHostnameVerification;
        this.revocationStrategy = revocationStrategy;
    }

    @Override
    public boolean requiresEncryption() {
        return this.requiresEncryption;
    }

    @Override
    public SSLContext sslContext() {
        return this.sslContext;
    }

    @Override
    public boolean requiresHostnameVerification() {
        return this.requiresHostnameVerification;
    }

    @Override
    public RevocationStrategy revocationStrategy() {
        return this.revocationStrategy;
    }

    private static class TrustAllTrustManager
    implements X509TrustManager {
        private TrustAllTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new CertificateException("All client connections to this client are forbidden.");
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

