/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen.source;

import java.util.List;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.neo4j.codegen.ByteCodes;
import org.neo4j.codegen.CodeGenerationStrategy;
import org.neo4j.codegen.CodeGenerationStrategyNotSupportedException;
import org.neo4j.codegen.CompilationFailureException;
import org.neo4j.codegen.source.Configuration;
import org.neo4j.codegen.source.FileManager;
import org.neo4j.codegen.source.JavaSourceFile;
import org.neo4j.codegen.source.SourceCompiler;

class JdkCompiler
implements SourceCompiler {
    public static final SourceCompiler.Factory FACTORY = new SourceCompiler.Factory(){

        @Override
        SourceCompiler sourceCompilerFor(Configuration configuration, CodeGenerationStrategy<?> strategy) throws CodeGenerationStrategyNotSupportedException {
            JavaCompiler jdkCompiler = ToolProvider.getSystemJavaCompiler();
            if (jdkCompiler == null) {
                throw new CodeGenerationStrategyNotSupportedException(strategy, "no java source compiler available");
            }
            return new JdkCompiler(jdkCompiler, configuration);
        }
    };
    private final JavaCompiler compiler;
    private final Configuration configuration;

    JdkCompiler(JavaCompiler compiler, Configuration configuration) {
        this.compiler = compiler;
        this.configuration = configuration;
    }

    @Override
    public Iterable<? extends ByteCodes> compile(List<JavaSourceFile> sourceFiles, ClassLoader loader) throws CompilationFailureException {
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        FileManager fileManager = new FileManager(this.compiler.getStandardFileManager(diagnostics, this.configuration.locale(), this.configuration.charset()));
        JavaCompiler.CompilationTask task = this.compiler.getTask(this.configuration.errorWriter(), fileManager, diagnostics, this.configuration.options(), null, sourceFiles);
        this.configuration.processors(task);
        if (task.call().booleanValue()) {
            this.configuration.warningsHandler().handle(diagnostics.getDiagnostics());
            return fileManager.bytecodes();
        }
        List issues = diagnostics.getDiagnostics();
        throw new CompilationFailureException(issues);
    }
}

