/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

public interface CountsVisitor {
    public void visitNodeCount(int var1, long var2);

    public void visitRelationshipCount(int var1, int var2, int var3, long var4);

    public void visitIndexStatistics(int var1, int var2, long var3, long var5);

    public void visitIndexSample(int var1, int var2, long var3, long var5);

    public static class Adapter
    implements CountsVisitor {
        @Override
        public void visitNodeCount(int labelId, long count) {
        }

        @Override
        public void visitRelationshipCount(int startLabelId, int typeId, int endLabelId, long count) {
        }

        @Override
        public void visitIndexStatistics(int labelId, int propertyKeyId, long updates, long size) {
        }

        @Override
        public void visitIndexSample(int labelId, int propertyKeyId, long unique, long size) {
        }

        public static CountsVisitor multiplex(final CountsVisitor ... visitors) {
            return new CountsVisitor(){

                @Override
                public void visitNodeCount(int labelId, long count) {
                    for (CountsVisitor visitor : visitors) {
                        visitor.visitNodeCount(labelId, count);
                    }
                }

                @Override
                public void visitRelationshipCount(int startLabelId, int typeId, int endLabelId, long count) {
                    for (CountsVisitor visitor : visitors) {
                        visitor.visitRelationshipCount(startLabelId, typeId, endLabelId, count);
                    }
                }

                @Override
                public void visitIndexStatistics(int labelId, int propertyKeyId, long updates, long size) {
                    for (CountsVisitor visitor : visitors) {
                        visitor.visitIndexStatistics(labelId, propertyKeyId, updates, size);
                    }
                }

                @Override
                public void visitIndexSample(int labelId, int propertyKeyId, long unique, long size) {
                    for (CountsVisitor visitor : visitors) {
                        visitor.visitIndexSample(labelId, propertyKeyId, unique, size);
                    }
                }
            };
        }
    }

    public static interface Visitable {
        public void accept(CountsVisitor var1);
    }
}

