/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.cache.CacheProvider;
import org.neo4j.kernel.impl.core.Caches;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.monitoring.Monitors;

public class DefaultCaches
implements Caches {
    private CacheProvider provider;
    private Config config;
    private final StringLogger logger;
    private final Monitors monitors;
    private Cache<NodeImpl> nodeCache;
    private Cache<RelationshipImpl> relCache;

    public DefaultCaches(StringLogger logger, Monitors monitors) {
        this.logger = logger;
        this.monitors = monitors;
    }

    @Override
    public void configure(CacheProvider provider, Config config) {
        this.provider = provider;
        this.config = config;
    }

    @Override
    public Cache<NodeImpl> node() {
        if (this.nodeCache == null) {
            this.nodeCache = this.provider.newNodeCache(this.logger, this.config, this.monitors);
        }
        return this.nodeCache;
    }

    @Override
    public Cache<RelationshipImpl> relationship() {
        if (this.relCache == null) {
            this.relCache = this.provider.newRelationshipCache(this.logger, this.config, this.monitors);
        }
        return this.relCache;
    }

    @Override
    public void clear() {
        if (this.nodeCache != null) {
            this.nodeCache.clear();
        }
        if (this.relCache != null) {
            this.relCache.clear();
        }
    }

    @Override
    public void invalidate() {
    }

    @Override
    public CacheProvider getProvider() {
        return this.provider;
    }
}

