/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.NoSuchElementException;
import org.neo4j.cursor.Cursor;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.core.NodeProxy;

public class RelationshipConversion
implements RelationshipVisitor<RuntimeException>,
ResourceIterator<Relationship> {
    private final NodeProxy.NodeActions actions;
    Cursor cursor;
    Statement statement;
    private Relationship next;

    public RelationshipConversion(NodeProxy.NodeActions actions) {
        this.actions = actions;
    }

    @Override
    public void visit(long relId, int type, long startNode, long endNode) throws RuntimeException {
        this.next = this.actions.newRelationshipProxy(relId, startNode, type, endNode);
    }

    @Override
    public boolean hasNext() {
        return this.next != null || this.cursor.next();
    }

    @Override
    public Relationship next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Relationship current = this.next;
        this.next = null;
        return current;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        this.cursor.close();
        this.statement.close();
    }
}

