/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import java.nio.ByteBuffer;
import org.neo4j.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.kernel.impl.store.UniquenessConstraintRule;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.RecordSerializable;

public interface SchemaRule
extends RecordSerializable {
    public long getId();

    public int getLabel();

    public Kind getKind();

    public static abstract class Kind
    extends Enum<Kind> {
        public static final /* enum */ Kind INDEX_RULE = new Kind(1, IndexRule.class){

            @Override
            protected SchemaRule newRule(long id, int labelId, ByteBuffer buffer) {
                return IndexRule.readIndexRule(id, false, labelId, buffer);
            }
        };
        public static final /* enum */ Kind CONSTRAINT_INDEX_RULE = new Kind(2, IndexRule.class){

            @Override
            protected SchemaRule newRule(long id, int labelId, ByteBuffer buffer) {
                return IndexRule.readIndexRule(id, true, labelId, buffer);
            }
        };
        public static final /* enum */ Kind UNIQUENESS_CONSTRAINT = new Kind(3, UniquenessConstraintRule.class){

            @Override
            protected SchemaRule newRule(long id, int labelId, ByteBuffer buffer) {
                return UniquenessConstraintRule.readUniquenessConstraintRule(id, labelId, buffer);
            }
        };
        private final byte id;
        private final Class<? extends SchemaRule> ruleClass;
        private static final /* synthetic */ Kind[] $VALUES;

        public static Kind[] values() {
            return (Kind[])$VALUES.clone();
        }

        public static Kind valueOf(String name) {
            return Enum.valueOf(Kind.class, name);
        }

        private Kind(int id, Class<? extends SchemaRule> ruleClass) {
            assert (id > 0) : "Kind id 0 is reserved";
            this.id = (byte)id;
            this.ruleClass = ruleClass;
        }

        public Class<? extends SchemaRule> getRuleClass() {
            return this.ruleClass;
        }

        public byte id() {
            return this.id;
        }

        protected abstract SchemaRule newRule(long var1, int var3, ByteBuffer var4);

        public static SchemaRule deserialize(long id, ByteBuffer buffer) throws MalformedSchemaRuleException {
            int labelId = buffer.getInt();
            Kind kind = Kind.kindForId(buffer.get());
            try {
                SchemaRule rule = kind.newRule(id, labelId, buffer);
                if (null == rule) {
                    throw new MalformedSchemaRuleException(null, "Deserialized null schema rule for id %d with kind %s", new Object[]{id, kind.name()});
                }
                return rule;
            }
            catch (Exception e) {
                throw new MalformedSchemaRuleException(e, "Could not deserialize schema rule for id %d with kind %s", id, kind.name());
            }
        }

        public static Kind kindForId(byte id) throws MalformedSchemaRuleException {
            switch (id) {
                case 1: {
                    return INDEX_RULE;
                }
                case 2: {
                    return CONSTRAINT_INDEX_RULE;
                }
                case 3: {
                    return UNIQUENESS_CONSTRAINT;
                }
            }
            throw new MalformedSchemaRuleException(null, "Unknown kind id %d", new Object[]{id});
        }

        public boolean isIndex() {
            return this.ruleClass == IndexRule.class;
        }

        static {
            $VALUES = new Kind[]{INDEX_RULE, CONSTRAINT_INDEX_RULE, UNIQUENESS_CONSTRAINT};
        }
    }
}

