/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.util.TimeZone;
import org.neo4j.helpers.Format;
import org.neo4j.kernel.impl.transaction.log.entry.AbstractLogEntry;

public abstract class LogEntryCommit
extends AbstractLogEntry {
    private final long txId;
    private final long timeWritten;
    protected final String name;

    LogEntryCommit(byte type, byte version, long txId, long timeWritten, String name) {
        super(type, version);
        this.txId = txId;
        this.timeWritten = timeWritten;
        this.name = name;
    }

    public long getTxId() {
        return this.txId;
    }

    public long getTimeWritten() {
        return this.timeWritten;
    }

    public String toString() {
        return this.toString(Format.DEFAULT_TIME_ZONE);
    }

    @Override
    public String toString(TimeZone timeZone) {
        return this.name + "[txId=" + this.getTxId() + ", " + this.timestamp(this.getTimeWritten(), timeZone) + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogEntryCommit commit = (LogEntryCommit)o;
        if (this.timeWritten != commit.timeWritten) {
            return false;
        }
        if (this.txId != commit.txId) {
            return false;
        }
        return this.name.equals(commit.name);
    }

    public int hashCode() {
        int result = (int)(this.txId ^ this.txId >>> 32);
        result = 31 * result + (int)(this.timeWritten ^ this.timeWritten >>> 32);
        result = 31 * result + this.name.hashCode();
        return result;
    }
}

