/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.Provider;
import org.neo4j.kernel.impl.util.DependencySatisfier;

public class Dependencies
extends DependencyResolver.Adapter
implements DependencySatisfier {
    private final Provider<DependencyResolver> parent;
    private final Map<Class<?>, List<?>> typeDependencies = new HashMap();

    public Dependencies() {
        this.parent = null;
    }

    public Dependencies(final DependencyResolver parent) {
        this.parent = new Provider<DependencyResolver>(){

            @Override
            public DependencyResolver instance() {
                return parent;
            }
        };
    }

    public Dependencies(Provider<DependencyResolver> parent) {
        this.parent = parent;
    }

    @Override
    public <T> T resolveDependency(Class<T> type, DependencyResolver.SelectionStrategy selector) {
        List<?> options = this.typeDependencies.get(type);
        if (options != null) {
            return selector.select(type, options);
        }
        if (this.parent != null) {
            return this.parent.instance().resolveDependency(type, selector);
        }
        throw new IllegalArgumentException("Weird exception nesting here, but anyways, I couldn't find any dependency for " + type);
    }

    public <T> Provider<T> provideDependency(final Class<T> type, final DependencyResolver.SelectionStrategy selector) {
        return new Provider<T>(){

            @Override
            public T instance() {
                return Dependencies.this.resolveDependency(type, selector);
            }
        };
    }

    public <T> Provider<T> provideDependency(final Class<T> type) {
        return new Provider<T>(){

            @Override
            public T instance() {
                return Dependencies.this.resolveDependency(type);
            }
        };
    }

    @Override
    public <T> T satisfyDependency(T dependency) {
        Class<?> type = dependency.getClass();
        do {
            List<?> deps;
            if ((deps = this.typeDependencies.get(type)) == null) {
                deps = new ArrayList();
                this.typeDependencies.put(type, deps);
            }
            deps.add(dependency);
            Class[] interfaces = type.getInterfaces();
            this.addInterfaces(interfaces, dependency);
        } while ((type = type.getSuperclass()) != null);
        return dependency;
    }

    private <T> void addInterfaces(Class[] interfaces, T dependency) {
        for (Class type : interfaces) {
            List<?> deps = this.typeDependencies.get(type);
            if (deps == null) {
                deps = new ArrayList();
                this.typeDependencies.put(type, deps);
            }
            deps.add(dependency);
            this.addInterfaces(type.getInterfaces(), dependency);
        }
    }
}

