/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Comparator;
import java.util.TimeZone;
import java.util.TreeSet;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.Format;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.IOCursor;
import org.neo4j.kernel.impl.transaction.log.LogDeserializer;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderReader;

public class DumpLogicalLog {
    private static final String TO_FILE = "tofile";
    private final FileSystemAbstraction fileSystem;
    private static final Printer SYSTEM_OUT_PRINTER = new Printer(){

        @Override
        public PrintStream getFor(String file) {
            return System.out;
        }

        @Override
        public void close() {
        }
    };

    public DumpLogicalLog(FileSystemAbstraction fileSystem) {
        this.fileSystem = fileSystem;
    }

    public int dump(String filenameOrDirectory, String logPrefix, PrintStream out, TimeZone timeZone) throws IOException {
        int logsFound = 0;
        for (String fileName : this.filenamesOf(filenameOrDirectory, logPrefix)) {
            LogHeader logHeader;
            ++logsFound;
            out.println("=== " + fileName + " ===");
            StoreChannel fileChannel = this.fileSystem.open(new File(fileName), "r");
            ByteBuffer buffer = ByteBuffer.allocateDirect(713);
            try {
                logHeader = LogHeaderReader.readLogHeader(buffer, (ReadableByteChannel)fileChannel, false);
            }
            catch (IOException ex) {
                out.println("Unable to read timestamp information, no records in logical log.");
                out.println(ex.getMessage());
                fileChannel.close();
                throw ex;
            }
            out.println("Logical log format:" + logHeader.logFormatVersion + "version: " + logHeader.logVersion + " with prev committed tx[" + logHeader.lastCommittedTxId + "]");
            LogDeserializer deserializer = new LogDeserializer();
            PhysicalLogVersionedStoreChannel channel = new PhysicalLogVersionedStoreChannel(fileChannel, logHeader.logVersion, logHeader.logFormatVersion);
            ReadAheadLogChannel logChannel = new ReadAheadLogChannel(channel, LogVersionBridge.NO_MORE_CHANNELS, 4096);
            try (IOCursor<LogEntry> cursor = deserializer.logEntries(logChannel);){
                while (cursor.next()) {
                    out.println(cursor.get().toString(timeZone));
                }
            }
        }
        return logsFound;
    }

    protected static boolean isAGraphDatabaseDirectory(String fileName) {
        File file = new File(fileName);
        return file.isDirectory() && new File(file, "neostore").exists();
    }

    public static void main(String[] args) throws IOException {
        Args arguments = Args.withFlags(TO_FILE).parse(args);
        TimeZone timeZone = DumpLogicalLog.parseTimeZoneConfig(arguments);
        try (Printer printer = DumpLogicalLog.getPrinter(arguments);){
            for (String fileAsString : arguments.orphans()) {
                new DumpLogicalLog((FileSystemAbstraction)new DefaultFileSystemAbstraction()).dump(fileAsString, "neostore.transaction.db", printer.getFor(fileAsString), timeZone);
            }
        }
    }

    public static Printer getPrinter(Args args) {
        boolean toFile = args.getBoolean(TO_FILE, false, true);
        return toFile ? new FilePrinter() : SYSTEM_OUT_PRINTER;
    }

    public static TimeZone parseTimeZoneConfig(Args arguments) {
        return TimeZone.getTimeZone(arguments.get("timezone", Format.DEFAULT_TIME_ZONE.getID()));
    }

    protected String[] filenamesOf(String filenameOrDirectory, final String prefix) {
        File file = new File(filenameOrDirectory);
        if (this.fileSystem.isDirectory(file)) {
            File[] files = this.fileSystem.listFiles(file, new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.contains(prefix) && !name.contains("active");
                }
            });
            TreeSet<? super String> result = new TreeSet<String>(DumpLogicalLog.sequentialComparator());
            for (int i = 0; i < files.length; ++i) {
                result.add(files[i].getPath());
            }
            return result.toArray(new String[result.size()]);
        }
        return new String[]{filenameOrDirectory};
    }

    private static Comparator<? super String> sequentialComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return this.versionOf(o1).compareTo(this.versionOf(o2));
            }

            private Long versionOf(String string) {
                try {
                    return PhysicalLogFiles.getLogVersion(string);
                }
                catch (RuntimeException ignored) {
                    return Long.MAX_VALUE;
                }
            }
        };
    }

    private static class FilePrinter
    implements Printer {
        private File directory;
        private PrintStream out;

        private FilePrinter() {
        }

        @Override
        public PrintStream getFor(String file) throws FileNotFoundException {
            File dir;
            File absoluteFile = new File(file).getAbsoluteFile();
            File file2 = dir = absoluteFile.isDirectory() ? absoluteFile : absoluteFile.getParentFile();
            if (!dir.equals(this.directory)) {
                this.safeClose();
                File dumpFile = new File(dir, "dump-logical-log.txt");
                System.out.println("Redirecting the output to " + dumpFile.getPath());
                this.out = new PrintStream(dumpFile);
                this.directory = dir;
            }
            return this.out;
        }

        private void safeClose() {
            if (this.out != null) {
                this.out.close();
            }
        }

        @Override
        public void close() {
            this.safeClose();
        }
    }

    public static interface Printer
    extends AutoCloseable {
        public PrintStream getFor(String var1) throws FileNotFoundException;

        @Override
        public void close();
    }
}

