/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.io.PrintStream;
import java.util.concurrent.TimeUnit;
import org.neo4j.helpers.Format;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;
import org.neo4j.unsafe.impl.batchimport.staging.Step;
import org.neo4j.unsafe.impl.batchimport.stats.DetailLevel;
import org.neo4j.unsafe.impl.batchimport.stats.Keys;
import org.neo4j.unsafe.impl.batchimport.stats.StepStats;

public class DetailedExecutionMonitor
extends ExecutionMonitor.Adpter {
    private final PrintStream out;

    public DetailedExecutionMonitor(PrintStream out) {
        this(out, 5L);
    }

    public DetailedExecutionMonitor(PrintStream out, long intervalSeconds) {
        super(intervalSeconds, TimeUnit.SECONDS);
        this.out = out;
    }

    @Override
    public void start(StageExecution[] executions) {
        StringBuilder names = new StringBuilder();
        for (StageExecution execution : executions) {
            names.append(names.length() > 0 ? ", " : "").append(execution.getStageName());
        }
        this.out.println(String.format("%n>>>>> EXECUTING STAGE(s) %s <<<<<%n", names));
    }

    @Override
    public void end(StageExecution[] executions, long totalTimeMillis) {
        this.out.println("Stage total time " + Format.duration(totalTimeMillis));
    }

    @Override
    public void check(StageExecution[] executions) {
        boolean first = true;
        for (StageExecution execution : executions) {
            this.printStats(execution, first);
            first = false;
        }
    }

    private void printStats(StageExecution execution, boolean first) {
        Step<?> bottleNeck = execution.stepsOrderedBy(Keys.avg_processing_time, false).iterator().next().first();
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (Step<?> step : execution.steps()) {
            StepStats stats = step.stats();
            builder.append(i > 0 ? String.format("%n  ", new Object[0]) : (first ? "--" : " -")).append(stats.toString(DetailLevel.BASIC)).append(step == bottleNeck ? "  <== BOTTLE NECK" : "");
            ++i;
        }
        String toPrint = builder.toString();
        this.printAndBackUpAgain(toPrint);
    }

    private void printAndBackUpAgain(String toPrint) {
        this.out.println(toPrint);
    }
}

