/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory;

import java.io.File;
import java.util.Map;
import javax.annotation.Nonnull;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactoryState;
import org.neo4j.graphdb.security.URLAccessRule;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.CommunityEditionModule;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.Edition;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;

public class GraphDatabaseFactory {
    private final GraphDatabaseFactoryState state;

    public GraphDatabaseFactory() {
        this(new GraphDatabaseFactoryState());
    }

    protected GraphDatabaseFactory(GraphDatabaseFactoryState state) {
        this.state = state;
    }

    protected GraphDatabaseFactoryState getCurrentState() {
        return this.state;
    }

    protected GraphDatabaseFactoryState getStateCopy() {
        return new GraphDatabaseFactoryState(this.getCurrentState());
    }

    public GraphDatabaseService newEmbeddedDatabase(File storeDir) {
        return this.newEmbeddedDatabaseBuilder(storeDir).newGraphDatabase();
    }

    public GraphDatabaseBuilder newEmbeddedDatabaseBuilder(File storeDir) {
        GraphDatabaseFactoryState state = this.getStateCopy();
        GraphDatabaseBuilder.DatabaseCreator creator = this.createDatabaseCreator(storeDir, state);
        GraphDatabaseBuilder builder = this.createGraphDatabaseBuilder(creator);
        this.configure(builder);
        return builder;
    }

    protected GraphDatabaseBuilder createGraphDatabaseBuilder(GraphDatabaseBuilder.DatabaseCreator creator) {
        return new GraphDatabaseBuilder(creator);
    }

    protected GraphDatabaseBuilder.DatabaseCreator createDatabaseCreator(final File storeDir, final GraphDatabaseFactoryState state) {
        return new GraphDatabaseBuilder.DatabaseCreator(){

            @Override
            public GraphDatabaseService newDatabase(Map<String, String> config) {
                return this.newDatabase(Config.embeddedDefaults(config));
            }

            @Override
            public GraphDatabaseService newDatabase(@Nonnull Config config) {
                return GraphDatabaseFactory.this.newEmbeddedDatabase(storeDir, config.with(MapUtil.stringMap((String[])new String[]{"unsupported.dbms.ephemeral", "false"})), state.databaseDependencies());
            }
        };
    }

    protected void configure(GraphDatabaseBuilder builder) {
    }

    @Deprecated
    protected GraphDatabaseService newDatabase(File storeDir, Map<String, String> settings, GraphDatabaseFacadeFactory.Dependencies dependencies) {
        return this.newDatabase(storeDir, Config.embeddedDefaults(settings), dependencies);
    }

    protected GraphDatabaseService newEmbeddedDatabase(File storeDir, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
        return this.newDatabase(storeDir, config, dependencies);
    }

    protected GraphDatabaseService newDatabase(File storeDir, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
        return new GraphDatabaseFacadeFactory(DatabaseInfo.COMMUNITY, CommunityEditionModule::new).newFacade(storeDir, config, dependencies);
    }

    public GraphDatabaseFactory addURLAccessRule(String protocol, URLAccessRule rule) {
        this.getCurrentState().addURLAccessRule(protocol, rule);
        return this;
    }

    public GraphDatabaseFactory setUserLogProvider(LogProvider userLogProvider) {
        this.getCurrentState().setUserLogProvider(userLogProvider);
        return this;
    }

    public GraphDatabaseFactory setMonitors(Monitors monitors) {
        this.getCurrentState().setMonitors(monitors);
        return this;
    }

    public String getEdition() {
        return Edition.community.toString();
    }
}

