/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.extension;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.neo4j.kernel.extension.KernelExtensionFactory;

public abstract class KernelExtensionUtil {
    private KernelExtensionUtil() {
    }

    public static String servicesClassPathEntryInformation() {
        String separator = System.lineSeparator();
        StringBuilder result = new StringBuilder("Kernel extensions available on classpath: ");
        StringBuilder classPath = new StringBuilder();
        for (String entry : System.getProperty("java.class.path").split(File.pathSeparator)) {
            File servicesDir;
            classPath.append(separator).append("  ").append(entry);
            File entryFile = new File(entry);
            if (!entryFile.isDirectory() || !(servicesDir = new File(new File(entryFile, "META-INF"), "services")).exists()) continue;
            result.append(separator).append("Listing service files and kernel extensions where possible in " + servicesDir + ":");
            for (File serviceFile : servicesDir.listFiles()) {
                if (!serviceFile.isFile()) continue;
                result.append(separator).append("  ").append(serviceFile.getName());
            }
            File extensionsFile = new File(servicesDir, KernelExtensionFactory.class.getName());
            if (!extensionsFile.exists()) continue;
            KernelExtensionUtil.appendKernelExtensionsList(extensionsFile, result, separator + "   + ");
        }
        return result.append(separator).append(separator).append("Class path entries:").append((CharSequence)classPath).toString();
    }

    private static void appendKernelExtensionsList(File file, StringBuilder to, String separator) {
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                boolean exists = KernelExtensionUtil.tryLoadClass(line);
                to.append(separator).append(line).append(" (" + (exists ? "exists" : "DOES NOT exist") + ")");
            }
        }
        catch (IOException e) {
            to.append("Couldn't read due to " + e.getMessage());
        }
    }

    private static boolean tryLoadClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

