/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.extension.dependency;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;

public class DeleteStoresFromOtherLabelScanStoreProviders
implements DependencyResolver.SelectionStrategy {
    private final LabelScanStoreProvider providerToKeep;

    public DeleteStoresFromOtherLabelScanStoreProviders(LabelScanStoreProvider providerToKeep) {
        this.providerToKeep = providerToKeep;
    }

    public <T> T select(Class<T> type, Iterable<T> candidates) throws IllegalArgumentException {
        for (T candidate : candidates) {
            if (!(candidate instanceof LabelScanStoreProvider)) {
                throw new IllegalArgumentException("May only be used for " + LabelScanStoreProvider.class);
            }
            LabelScanStoreProvider provider = (LabelScanStoreProvider)((Object)candidate);
            if (provider == this.providerToKeep) continue;
            try {
                if (provider.isReadOnly()) continue;
                provider.drop();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return (T)((Object)this.providerToKeep);
    }
}

