/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.kernel.impl.util.Validator;

public class IndexValueLengthValidator
implements Validator<byte[]> {
    static final int MAX_TERM_LENGTH = 32766;
    public static final IndexValueLengthValidator INSTANCE = new IndexValueLengthValidator();

    private IndexValueLengthValidator() {
    }

    @Override
    public void validate(byte[] bytes) {
        if (bytes.length > 32766) {
            throw new IllegalArgumentException("Property value bytes length: " + bytes.length + " is longer then " + 32766 + ", which is maximum supported length of indexed property value.");
        }
    }
}

