/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.function.Consumer;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.impl.locking.Lock;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.RecordCursors;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;
import org.neo4j.storageengine.api.NodeItem;

public class StoreSingleNodeCursor
implements Cursor<NodeItem>,
NodeItem {
    private final NodeRecord nodeRecord;
    private final Consumer<StoreSingleNodeCursor> instanceCache;
    private final LockService lockService;
    private final RecordCursors recordCursors;
    private long nodeId = -1L;
    private long[] labels;

    StoreSingleNodeCursor(NodeRecord nodeRecord, Consumer<StoreSingleNodeCursor> instanceCache, RecordCursors recordCursors, LockService lockService) {
        this.nodeRecord = nodeRecord;
        this.recordCursors = recordCursors;
        this.lockService = lockService;
        this.instanceCache = instanceCache;
    }

    public StoreSingleNodeCursor init(long nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    public NodeItem get() {
        return this;
    }

    public boolean next() {
        this.labels = null;
        if (this.nodeId != -1L) {
            try {
                boolean bl = this.recordCursors.node().next(this.nodeId, this.nodeRecord, RecordLoad.CHECK);
                return bl;
            }
            finally {
                this.nodeId = -1L;
            }
        }
        return false;
    }

    public void close() {
        this.labels = null;
        this.nodeRecord.clear();
        this.instanceCache.accept(this);
    }

    @Override
    public long id() {
        return this.nodeRecord.getId();
    }

    @Override
    public PrimitiveIntSet labels() {
        this.ensureLabels();
        return PrimitiveIntCollections.asSet((long[])this.labels, IoPrimitiveUtils::safeCastLongToInt);
    }

    private void ensureLabels() {
        if (this.labels == null) {
            this.labels = NodeLabelsField.get(this.nodeRecord, this.recordCursors.label());
        }
    }

    @Override
    public boolean hasLabel(int labelId) {
        this.ensureLabels();
        for (long label : this.labels) {
            if (IoPrimitiveUtils.safeCastLongToInt(label) != labelId) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDense() {
        return this.nodeRecord.isDense();
    }

    @Override
    public long nextGroupId() {
        assert (this.isDense());
        return this.nextRelationshipId();
    }

    @Override
    public long nextRelationshipId() {
        return this.nodeRecord.getNextRel();
    }

    @Override
    public long nextPropertyId() {
        return this.nodeRecord.getNextProp();
    }

    @Override
    public Lock lock() {
        Lock lock = this.lockService.acquireNodeLock(this.nodeRecord.getId(), LockService.LockType.READ_LOCK);
        if (this.lockService != LockService.NO_LOCK_SERVICE) {
            boolean success = false;
            try {
                if (!this.recordCursors.node().next(this.nodeRecord.getId(), this.nodeRecord, RecordLoad.CHECK)) {
                    this.nodeRecord.setNextProp(Record.NO_NEXT_PROPERTY.intValue());
                }
                success = true;
            }
            finally {
                if (!success) {
                    lock.release();
                }
            }
        }
        return lock;
    }
}

