/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking.community;

import java.time.Clock;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.locking.LockTracer;
import org.neo4j.kernel.impl.locking.community.LockNotFoundException;
import org.neo4j.kernel.impl.locking.community.LockResource;
import org.neo4j.kernel.impl.locking.community.RWLock;
import org.neo4j.kernel.impl.locking.community.RagManager;
import org.neo4j.kernel.impl.transaction.IllegalResourceException;
import org.neo4j.logging.Logger;

public class LockManagerImpl {
    private final Map<Object, RWLock> resourceLockMap = new HashMap<Object, RWLock>();
    private final RagManager ragManager;
    private final Clock clock;
    private long lockAcquisitionTimeoutMillis;

    public LockManagerImpl(RagManager ragManager, Config config, Clock clock) {
        this.ragManager = ragManager;
        this.clock = clock;
        this.lockAcquisitionTimeoutMillis = config.get(GraphDatabaseSettings.lock_acquisition_timeout).toMillis();
    }

    public boolean getReadLock(LockTracer tracer, LockResource resource, Object tx) throws DeadlockDetectedException, IllegalResourceException {
        return this.unusedResourceGuard(resource, tx, this.getRWLockForAcquiring(resource, tx).acquireReadLock(tracer, tx));
    }

    public boolean tryReadLock(LockResource resource, Object tx) throws IllegalResourceException {
        return this.unusedResourceGuard(resource, tx, this.getRWLockForAcquiring(resource, tx).tryAcquireReadLock(tx));
    }

    public boolean getWriteLock(LockTracer tracer, LockResource resource, Object tx) throws DeadlockDetectedException, IllegalResourceException {
        return this.unusedResourceGuard(resource, tx, this.getRWLockForAcquiring(resource, tx).acquireWriteLock(tracer, tx));
    }

    public boolean tryWriteLock(LockResource resource, Object tx) throws IllegalResourceException {
        return this.unusedResourceGuard(resource, tx, this.getRWLockForAcquiring(resource, tx).tryAcquireWriteLock(tx));
    }

    public void releaseReadLock(Object resource, Object tx) throws LockNotFoundException, IllegalResourceException {
        this.getRWLockForReleasing(resource, tx, 1, 0, true).releaseReadLock(tx);
    }

    public void releaseWriteLock(Object resource, Object tx) throws LockNotFoundException, IllegalResourceException {
        this.getRWLockForReleasing(resource, tx, 0, 1, true).releaseWriteLock(tx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpLocksOnResource(Object resource, Logger logger) {
        RWLock lock;
        Map<Object, RWLock> map = this.resourceLockMap;
        synchronized (map) {
            if (!this.resourceLockMap.containsKey(resource)) {
                logger.log("No locks on " + resource);
                return;
            }
            lock = this.resourceLockMap.get(resource);
        }
        logger.bulk(bulkLogger -> {
            bulkLogger.log("Dump locks on resource %s", new Object[]{resource});
            lock.logTo((Logger)bulkLogger);
        });
    }

    private boolean unusedResourceGuard(Object resource, Object tx, boolean lockObtained) {
        if (!lockObtained) {
            this.getRWLockForReleasing(resource, tx, 0, 0, false);
        }
        return lockObtained;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(Visitor<RWLock, RuntimeException> visitor) {
        Map<Object, RWLock> map = this.resourceLockMap;
        synchronized (map) {
            for (RWLock lock : this.resourceLockMap.values()) {
                if (visitor.visit((Object)lock)) break;
            }
        }
    }

    private void assertValidArguments(Object resource, Object tx) {
        if (resource == null || tx == null) {
            throw new IllegalResourceException("Null parameter: resource = " + resource + ", tx = " + tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RWLock getRWLockForAcquiring(LockResource resource, Object tx) {
        this.assertValidArguments(resource, tx);
        Map<Object, RWLock> map = this.resourceLockMap;
        synchronized (map) {
            RWLock lock = this.resourceLockMap.get(resource);
            if (lock == null) {
                lock = this.createLock(resource);
                this.resourceLockMap.put(resource, lock);
            }
            lock.mark();
            return lock;
        }
    }

    protected RWLock createLock(LockResource resource) {
        return new RWLock(resource, this.ragManager, this.clock, this.lockAcquisitionTimeoutMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RWLock getRWLockForReleasing(Object resource, Object tx, int readCountPrerequisite, int writeCountPrerequisite, boolean strict) {
        this.assertValidArguments(resource, tx);
        Map<Object, RWLock> map = this.resourceLockMap;
        synchronized (map) {
            RWLock lock = this.resourceLockMap.get(resource);
            if (lock == null) {
                if (!strict) {
                    return null;
                }
                throw new LockNotFoundException("Lock not found for: " + resource + " tx:" + tx);
            }
            RWLock rWLock = lock;
            synchronized (rWLock) {
                if (!lock.isMarked() && lock.getReadCount() == readCountPrerequisite && lock.getWriteCount() == writeCountPrerequisite && lock.getWaitingThreadsCount() == 0) {
                    this.resourceLockMap.remove(resource);
                }
            }
            return lock;
        }
    }
}

