/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query.clientconnection;

public abstract class ClientConnectionInfo {
    public static final ClientConnectionInfo EMBEDDED_CONNECTION = new ClientConnectionInfo(){

        @Override
        public String asConnectionDetails() {
            return "embedded-session\t";
        }

        @Override
        public String protocol() {
            return "embedded";
        }
    };

    @Deprecated
    public ClientConnectionInfo withUsername(String username) {
        return new ConnectionInfoWithUsername(this, username);
    }

    @Deprecated
    public abstract String asConnectionDetails();

    public abstract String protocol();

    public String clientAddress() {
        return null;
    }

    public String requestURI() {
        return null;
    }

    @Deprecated
    private static class ConnectionInfoWithUsername
    extends ClientConnectionInfo {
        private final ClientConnectionInfo source;
        private final String username;

        private ConnectionInfoWithUsername(ClientConnectionInfo source, String username) {
            this.source = source;
            this.username = username;
        }

        @Override
        public String asConnectionDetails() {
            return this.source.asConnectionDetails() + '\t' + this.username;
        }

        @Override
        public String protocol() {
            return this.source.protocol();
        }

        @Override
        public String clientAddress() {
            return this.source.clientAddress();
        }

        @Override
        public String requestURI() {
            return this.source.requestURI();
        }
    }
}

