/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.collection.primitive.PrimitiveLongObjectVisitor;
import org.neo4j.collection.primitive.PrimitiveLongVisitor;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.DuplicateCluster;
import org.neo4j.kernel.impl.transaction.state.Loaders;
import org.neo4j.kernel.impl.transaction.state.TokenCreator;
import org.neo4j.storageengine.api.Token;
import org.neo4j.unsafe.batchinsert.DirectRecordAccess;

class NonIndexedConflictResolver
implements PrimitiveLongObjectVisitor<List<DuplicateCluster>, IOException> {
    private final PropertyKeyTokenStore keyTokenStore;
    private final Map<String, Integer> propertyTokenMap;
    private final PropertyStore store;

    NonIndexedConflictResolver(PropertyKeyTokenStore keyTokenStore, PropertyStore store) throws IOException {
        this.keyTokenStore = keyTokenStore;
        this.propertyTokenMap = this.buildPropertyKeyIndex(keyTokenStore);
        this.store = store;
    }

    private Map<String, Integer> buildPropertyKeyIndex(PropertyKeyTokenStore tokenStore) throws IOException {
        List tokens = tokenStore.getTokens((int)tokenStore.getHighestPossibleIdInUse() + 1);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (Token token : tokens) {
            map.put(token.name(), token.id());
        }
        return map;
    }

    public boolean visited(long key, List<DuplicateCluster> duplicateClusters) throws IOException {
        for (DuplicateCluster duplicateCluster : duplicateClusters) {
            this.resolveConflict(duplicateCluster);
        }
        return false;
    }

    private void resolveConflict(DuplicateCluster duplicateCluster) throws IOException {
        assert (duplicateCluster.size() > 0);
        String oldName = ((Token)this.keyTokenStore.getToken(duplicateCluster.propertyKeyId)).name();
        DuplicateNameAssigner visitor = new DuplicateNameAssigner(duplicateCluster, oldName);
        duplicateCluster.propertyRecordIds.visitKeys((PrimitiveLongVisitor)visitor);
    }

    private int getOrCreatePropertyKeyToken(String name, PropertyKeyTokenStore keyTokenStore) throws IOException {
        Integer token = this.propertyTokenMap.get(name);
        if (token != null) {
            return token;
        }
        TokenCreator<PropertyKeyTokenRecord, Token> creator = new TokenCreator<PropertyKeyTokenRecord, Token>(keyTokenStore);
        DirectRecordAccess<Integer, PropertyKeyTokenRecord, Void> recordAccess = new DirectRecordAccess<Integer, PropertyKeyTokenRecord, Void>(keyTokenStore, Loaders.propertyKeyTokenLoader(keyTokenStore));
        int propertyKeyTokenId = (int)keyTokenStore.nextId();
        creator.createToken(name, propertyKeyTokenId, recordAccess);
        recordAccess.close();
        this.propertyTokenMap.put(name, propertyKeyTokenId);
        return propertyKeyTokenId;
    }

    private class DuplicateNameAssigner
    implements PrimitiveLongVisitor<IOException> {
        private final DuplicateCluster duplicateCluster;
        private final String oldName;
        private int index;
        private final PropertyRecord record;

        DuplicateNameAssigner(DuplicateCluster duplicateCluster, String oldName) {
            this.record = NonIndexedConflictResolver.this.store.newRecord();
            this.duplicateCluster = duplicateCluster;
            this.oldName = oldName;
        }

        public boolean visited(long propertyRecordId) throws IOException {
            NonIndexedConflictResolver.this.store.getRecord(propertyRecordId, this.record, RecordLoad.NORMAL);
            for (PropertyBlock block : this.record) {
                if (block.getKeyIndexId() != this.duplicateCluster.propertyKeyId) continue;
                if (this.index == 0) {
                    ++this.index;
                    continue;
                }
                block.setKeyIndexId(this.getNewPropertyKeyId());
            }
            NonIndexedConflictResolver.this.store.updateRecord(this.record);
            return false;
        }

        int getNewPropertyKeyId() throws IOException {
            String duplicateName = "__DUPLICATE_" + this.oldName + "_" + this.index;
            ++this.index;
            return NonIndexedConflictResolver.this.getOrCreatePropertyKeyToken(duplicateName, NonIndexedConflictResolver.this.keyTokenStore);
        }
    }
}

