/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.graphdb.Resource;

public class StripedLock {
    private final Stripe[] stripes;

    public StripedLock(int stripes) {
        this.stripes = new Stripe[stripes];
        for (int i = 0; i < stripes; ++i) {
            this.stripes[i] = new Stripe();
        }
    }

    public Resource lock(int stripe) {
        Stripe lock = this.stripes[stripe];
        lock.lock.lock();
        return lock;
    }

    private static class Stripe
    implements Resource {
        private final Lock lock = new ReentrantLock();

        private Stripe() {
        }

        public void close() {
            this.lock.unlock();
        }
    }
}

