/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.lang.reflect.Field;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.graphdb.QueryExecutionType;

class QueryExecutionTypeTest {
    QueryExecutionTypeTest() {
    }

    private static Stream<Arguments> parameters() {
        return Stream.of(Arguments.of((Object[])QueryExecutionTypeTest.verify(QueryExecutionTypeTest.that(QueryExecutionType.query((QueryExecutionType.QueryType)QueryExecutionType.QueryType.READ_ONLY)).canContainResults())), Arguments.of((Object[])QueryExecutionTypeTest.verify(QueryExecutionTypeTest.that(QueryExecutionType.query((QueryExecutionType.QueryType)QueryExecutionType.QueryType.READ_WRITE)).canContainResults().canUpdateData())), Arguments.of((Object[])QueryExecutionTypeTest.verify(QueryExecutionTypeTest.that(QueryExecutionType.query((QueryExecutionType.QueryType)QueryExecutionType.QueryType.WRITE)).canUpdateData())), Arguments.of((Object[])QueryExecutionTypeTest.verify(QueryExecutionTypeTest.that(QueryExecutionType.query((QueryExecutionType.QueryType)QueryExecutionType.QueryType.SCHEMA_WRITE)).canUpdateSchema())), Arguments.of((Object[])QueryExecutionTypeTest.verify(QueryExecutionTypeTest.that(QueryExecutionType.profiled((QueryExecutionType.QueryType)QueryExecutionType.QueryType.READ_ONLY)).isExplained().isProfiled().canContainResults())), Arguments.of((Object[])QueryExecutionTypeTest.verify(QueryExecutionTypeTest.that(QueryExecutionType.profiled((QueryExecutionType.QueryType)QueryExecutionType.QueryType.READ_WRITE)).isExplained().isProfiled().canContainResults().canUpdateData())), Arguments.of((Object[])QueryExecutionTypeTest.verify(QueryExecutionTypeTest.that(QueryExecutionType.profiled((QueryExecutionType.QueryType)QueryExecutionType.QueryType.WRITE)).isExplained().isProfiled().canUpdateData())), Arguments.of((Object[])QueryExecutionTypeTest.verify(QueryExecutionTypeTest.that(QueryExecutionType.profiled((QueryExecutionType.QueryType)QueryExecutionType.QueryType.SCHEMA_WRITE)).isExplained().isProfiled().canUpdateSchema())), Arguments.of((Object[])QueryExecutionTypeTest.verify(QueryExecutionTypeTest.that(QueryExecutionType.explained((QueryExecutionType.QueryType)QueryExecutionType.QueryType.READ_ONLY)).isExplained().isOnlyExplained())), Arguments.of((Object[])QueryExecutionTypeTest.verify(QueryExecutionTypeTest.that(QueryExecutionType.explained((QueryExecutionType.QueryType)QueryExecutionType.QueryType.READ_WRITE)).isExplained().isOnlyExplained())), Arguments.of((Object[])QueryExecutionTypeTest.verify(QueryExecutionTypeTest.that(QueryExecutionType.explained((QueryExecutionType.QueryType)QueryExecutionType.QueryType.WRITE)).isExplained().isOnlyExplained())), Arguments.of((Object[])QueryExecutionTypeTest.verify(QueryExecutionTypeTest.that(QueryExecutionType.explained((QueryExecutionType.QueryType)QueryExecutionType.QueryType.SCHEMA_WRITE)).isExplained().isOnlyExplained())), Arguments.of((Object[])QueryExecutionTypeTest.verify(QueryExecutionTypeTest.thatQueryOf(QueryExecutionType.explained((QueryExecutionType.QueryType)QueryExecutionType.QueryType.READ_ONLY)).canContainResults())), Arguments.of((Object[])QueryExecutionTypeTest.verify(QueryExecutionTypeTest.thatQueryOf(QueryExecutionType.explained((QueryExecutionType.QueryType)QueryExecutionType.QueryType.READ_WRITE)).canContainResults().canUpdateData())), Arguments.of((Object[])QueryExecutionTypeTest.verify(QueryExecutionTypeTest.thatQueryOf(QueryExecutionType.explained((QueryExecutionType.QueryType)QueryExecutionType.QueryType.WRITE)).canUpdateData())), Arguments.of((Object[])QueryExecutionTypeTest.verify(QueryExecutionTypeTest.thatQueryOf(QueryExecutionType.explained((QueryExecutionType.QueryType)QueryExecutionType.QueryType.SCHEMA_WRITE)).canUpdateSchema())));
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void verifyTest(Assumptions expected) {
        QueryExecutionType executionType = expected.type();
        Assertions.assertEquals((Object)expected.isProfiled, (Object)executionType.isProfiled());
        Assertions.assertEquals((Object)expected.requestedExecutionPlanDescription, (Object)executionType.requestedExecutionPlanDescription());
        Assertions.assertEquals((Object)expected.isExplained, (Object)executionType.isExplained());
        Assertions.assertEquals((Object)expected.canContainResults, (Object)executionType.canContainResults());
        Assertions.assertEquals((Object)expected.canUpdateData, (Object)executionType.canUpdateData());
        Assertions.assertEquals((Object)expected.canUpdateSchema, (Object)executionType.canUpdateSchema());
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void noneOtherLikeIt(Assumptions expected) {
        for (QueryExecutionType.QueryType queryType : QueryExecutionType.QueryType.values()) {
            for (QueryExecutionType type : new QueryExecutionType[]{QueryExecutionType.query((QueryExecutionType.QueryType)queryType), QueryExecutionType.profiled((QueryExecutionType.QueryType)queryType), QueryExecutionType.explained((QueryExecutionType.QueryType)queryType)}) {
                if (type == expected.type() || expected.type().isExplained() && type.isExplained()) continue;
                Assertions.assertFalse((expected.isProfiled == type.isProfiled() && expected.requestedExecutionPlanDescription == type.requestedExecutionPlanDescription() && expected.isExplained == type.isExplained() && expected.canContainResults == type.canContainResults() && expected.canUpdateData == type.canUpdateData() && expected.canUpdateSchema == type.canUpdateSchema() ? 1 : 0) != 0, (String)expected.type().toString());
            }
        }
    }

    private static Object[] verify(Assumptions assumptions) {
        return new Object[]{assumptions};
    }

    private static Assumptions that(QueryExecutionType type) {
        return new Assumptions(type, false);
    }

    private static Assumptions thatQueryOf(QueryExecutionType type) {
        return new Assumptions(type, true);
    }

    static class Assumptions {
        final QueryExecutionType type;
        final boolean convertToQuery;
        boolean isProfiled;
        boolean requestedExecutionPlanDescription;
        boolean isExplained;
        boolean canContainResults;
        boolean canUpdateData;
        boolean canUpdateSchema;

        Assumptions(QueryExecutionType type, boolean convertToQuery) {
            this.type = type;
            this.convertToQuery = convertToQuery;
        }

        public String toString() {
            StringBuilder result = new StringBuilder(this.type.toString());
            if (this.convertToQuery) {
                result.append(" (as query)");
            }
            String sep = ": ";
            for (Field field : this.getClass().getDeclaredFields()) {
                boolean value;
                if (field.getType() != Boolean.TYPE) continue;
                field.setAccessible(true);
                try {
                    value = field.getBoolean(this);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                result.append(sep).append('.').append(field.getName()).append("() == ").append(value);
                sep = ", ";
            }
            return result.toString();
        }

        Assumptions isProfiled() {
            this.isProfiled = true;
            return this;
        }

        Assumptions isExplained() {
            this.requestedExecutionPlanDescription = true;
            return this;
        }

        Assumptions isOnlyExplained() {
            this.isExplained = true;
            return this;
        }

        Assumptions canContainResults() {
            this.canContainResults = true;
            return this;
        }

        Assumptions canUpdateData() {
            this.canUpdateData = true;
            return this;
        }

        Assumptions canUpdateSchema() {
            this.canUpdateSchema = true;
            return this;
        }

        public QueryExecutionType type() {
            return this.convertToQuery ? QueryExecutionType.query((QueryExecutionType.QueryType)this.type.queryType()) : this.type;
        }
    }
}

