/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.index;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

class IndexEntryConflictExceptionTest {
    private static final int labelId = 1;
    private static final Value value = Values.of((Object)"hi");

    IndexEntryConflictExceptionTest() {
    }

    @Test
    void shouldMakeEntryConflicts() {
        LabelSchemaDescriptor schema = SchemaDescriptor.forLabel((int)1, (int[])new int[]{2});
        IndexEntryConflictException e = new IndexEntryConflictException(0L, 1L, new Value[]{value});
        MatcherAssert.assertThat((Object)e.evidenceMessage(TokenNameLookup.idTokenNameLookup, (SchemaDescriptor)schema), (Matcher)Matchers.equalTo((Object)"Both Node(0) and Node(1) have the label `label[1]` and property `property[2]` = 'hi'"));
    }

    @Test
    void shouldMakeEntryConflictsForOneNode() {
        LabelSchemaDescriptor schema = SchemaDescriptor.forLabel((int)1, (int[])new int[]{2});
        IndexEntryConflictException e = new IndexEntryConflictException(0L, -1L, new Value[]{value});
        MatcherAssert.assertThat((Object)e.evidenceMessage(TokenNameLookup.idTokenNameLookup, (SchemaDescriptor)schema), (Matcher)Matchers.equalTo((Object)"Node(0) already exists with label `label[1]` and property `property[2]` = 'hi'"));
    }

    @Test
    void shouldMakeCompositeEntryConflicts() {
        LabelSchemaDescriptor schema = SchemaDescriptor.forLabel((int)1, (int[])new int[]{2, 3, 4});
        ValueTuple values = ValueTuple.of((Object[])new Object[]{true, "hi", new long[]{6L, 4L}});
        IndexEntryConflictException e = new IndexEntryConflictException(0L, 1L, values);
        MatcherAssert.assertThat((Object)e.evidenceMessage(TokenNameLookup.idTokenNameLookup, (SchemaDescriptor)schema), (Matcher)Matchers.equalTo((Object)"Both Node(0) and Node(1) have the label `label[1]` and properties `property[2]` = true, `property[3]` = 'hi', `property[4]` = [6, 4]"));
    }
}

