/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.availability;

import java.time.Clock;
import org.apache.commons.lang3.mutable.MutableLong;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.neo4j.kernel.availability.AvailabilityListener;
import org.neo4j.kernel.availability.AvailabilityRequirement;
import org.neo4j.kernel.availability.CompositeDatabaseAvailabilityGuard;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.availability.DescriptiveAvailabilityRequirement;
import org.neo4j.kernel.availability.UnavailableException;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.TestDatabaseIdRepository;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.LifeExtension;

@ExtendWith(value={LifeExtension.class})
class CompositeDatabaseAvailabilityGuardTest {
    private final DescriptiveAvailabilityRequirement requirement = new DescriptiveAvailabilityRequirement("testRequirement");
    private CompositeDatabaseAvailabilityGuard compositeGuard;
    private DatabaseAvailabilityGuard defaultGuard;
    private DatabaseAvailabilityGuard systemGuard;
    private Clock mockClock;
    @Inject
    private LifeSupport life;

    CompositeDatabaseAvailabilityGuardTest() {
    }

    @BeforeEach
    void setUp() throws Throwable {
        this.mockClock = (Clock)Mockito.mock(Clock.class);
        this.compositeGuard = new CompositeDatabaseAvailabilityGuard(this.mockClock);
        this.defaultGuard = this.createDatabaseAvailabilityGuard(TestDatabaseIdRepository.randomNamedDatabaseId(), this.mockClock, this.compositeGuard);
        this.systemGuard = this.createDatabaseAvailabilityGuard(DatabaseIdRepository.NAMED_SYSTEM_DATABASE_ID, this.mockClock, this.compositeGuard);
        this.defaultGuard.start();
        this.systemGuard.start();
        this.compositeGuard.start();
    }

    @Test
    void availabilityRequirementOnMultipleGuards() {
        Assertions.assertTrue((boolean)this.defaultGuard.isAvailable());
        Assertions.assertTrue((boolean)this.systemGuard.isAvailable());
        this.compositeGuard.require((AvailabilityRequirement)new DescriptiveAvailabilityRequirement("testRequirement"));
        Assertions.assertFalse((boolean)this.defaultGuard.isAvailable());
        Assertions.assertFalse((boolean)this.systemGuard.isAvailable());
    }

    @Test
    void availabilityFulfillmentOnMultipleGuards() {
        this.compositeGuard.require((AvailabilityRequirement)this.requirement);
        Assertions.assertFalse((boolean)this.defaultGuard.isAvailable());
        Assertions.assertFalse((boolean)this.systemGuard.isAvailable());
        this.compositeGuard.fulfill((AvailabilityRequirement)this.requirement);
        Assertions.assertTrue((boolean)this.defaultGuard.isAvailable());
        Assertions.assertTrue((boolean)this.systemGuard.isAvailable());
    }

    @Test
    void availableWhenAllGuardsAreAvailable() {
        Assertions.assertTrue((boolean)this.compositeGuard.isAvailable());
        this.defaultGuard.require((AvailabilityRequirement)this.requirement);
        Assertions.assertFalse((boolean)this.compositeGuard.isAvailable());
    }

    @Test
    void compositeGuardDoesNotSupportListeners() {
        AvailabilityListener listener = (AvailabilityListener)Mockito.mock(AvailabilityListener.class);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.compositeGuard.addListener(listener));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.compositeGuard.removeListener(listener));
    }

    @Test
    void availabilityTimeoutSharedAcrossAllGuards() {
        this.compositeGuard.require((AvailabilityRequirement)this.requirement);
        MutableLong counter = new MutableLong();
        Mockito.when((Object)this.mockClock.millis()).thenAnswer(invocation -> {
            if (counter.longValue() == 7L) {
                this.defaultGuard.fulfill((AvailabilityRequirement)this.requirement);
            }
            return counter.incrementAndGet();
        });
        Assertions.assertFalse((boolean)this.compositeGuard.isAvailable(10L));
        MatcherAssert.assertThat((Object)counter.getValue(), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(20L)));
        Assertions.assertTrue((boolean)this.defaultGuard.isAvailable());
        Assertions.assertFalse((boolean)this.systemGuard.isAvailable());
    }

    @Test
    void awaitCheckTimeoutSharedAcrossAllGuards() {
        this.compositeGuard.require((AvailabilityRequirement)this.requirement);
        MutableLong counter = new MutableLong();
        Mockito.when((Object)this.mockClock.millis()).thenAnswer(invocation -> {
            if (counter.longValue() == 7L) {
                this.defaultGuard.fulfill((AvailabilityRequirement)this.requirement);
            }
            return counter.incrementAndGet();
        });
        Assertions.assertThrows(UnavailableException.class, () -> this.compositeGuard.await(10L));
        MatcherAssert.assertThat((Object)counter.getValue(), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(20L)));
        Assertions.assertTrue((boolean)this.defaultGuard.isAvailable());
        Assertions.assertFalse((boolean)this.systemGuard.isAvailable());
    }

    @Test
    void stopOfAvailabilityGuardDeregisterItInCompositeParent() throws Exception {
        int initialGuards = this.compositeGuard.getGuards().size();
        DatabaseAvailabilityGuard firstGuard = this.createDatabaseAvailabilityGuard(TestDatabaseIdRepository.randomNamedDatabaseId(), this.mockClock, this.compositeGuard);
        DatabaseAvailabilityGuard secondGuard = this.createDatabaseAvailabilityGuard(TestDatabaseIdRepository.randomNamedDatabaseId(), this.mockClock, this.compositeGuard);
        firstGuard.start();
        secondGuard.start();
        Assertions.assertEquals((int)2, (int)this.countNewGuards(initialGuards));
        new Lifespan(new Lifecycle[]{firstGuard}).close();
        Assertions.assertEquals((int)1, (int)this.countNewGuards(initialGuards));
        new Lifespan(new Lifecycle[]{secondGuard}).close();
        Assertions.assertEquals((int)0, (int)this.countNewGuards(initialGuards));
    }

    @Test
    void compositeGuardIsAvailableByDefault() {
        CompositeDatabaseAvailabilityGuard testGuard = new CompositeDatabaseAvailabilityGuard(this.mockClock);
        Assertions.assertTrue((boolean)testGuard.isAvailable());
    }

    @Test
    void guardIsShutdownStateAfterStop() throws Throwable {
        CompositeDatabaseAvailabilityGuard testGuard = new CompositeDatabaseAvailabilityGuard(this.mockClock);
        testGuard.start();
        Assertions.assertFalse((boolean)testGuard.isShutdown());
        testGuard.stop();
        Assertions.assertTrue((boolean)testGuard.isShutdown());
    }

    @Test
    void stoppedGuardIsNotAvailableInAwait() throws Throwable {
        CompositeDatabaseAvailabilityGuard testGuard = new CompositeDatabaseAvailabilityGuard(this.mockClock);
        testGuard.start();
        Assertions.assertDoesNotThrow(() -> testGuard.await(0L));
        testGuard.stop();
        Assertions.assertThrows(UnavailableException.class, () -> testGuard.await(0L));
    }

    private int countNewGuards(int initialGuards) {
        return this.compositeGuard.getGuards().size() - initialGuards;
    }

    private DatabaseAvailabilityGuard createDatabaseAvailabilityGuard(NamedDatabaseId namedDatabaseId, Clock clock, CompositeDatabaseAvailabilityGuard compositeGuard) {
        DatabaseAvailabilityGuard availabilityGuard = new DatabaseAvailabilityGuard(namedDatabaseId, clock, (Log)NullLog.getInstance(), 0L, compositeGuard);
        this.life.add((Lifecycle)availabilityGuard);
        return availabilityGuard;
    }
}

