/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.diagnostics.providers;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.TreeMap;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.collection.Dependencies;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.dbms.database.StandaloneDatabaseContext;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.TestDatabaseIdRepository;
import org.neo4j.kernel.diagnostics.providers.DbmsDiagnosticsManager;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.SimpleLogService;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageEngineFactory;

class DbmsDiagnosticsManagerTest {
    private static final NamedDatabaseId DEFAULT_DATABASE_ID = TestDatabaseIdRepository.randomNamedDatabaseId();
    private static final String DEFAULT_DATABASE_NAME = DEFAULT_DATABASE_ID.name();
    private DbmsDiagnosticsManager diagnosticsManager;
    private AssertableLogProvider logProvider;
    private DatabaseManager<StandaloneDatabaseContext> databaseManager;
    private StorageEngine storageEngine;
    private StorageEngineFactory storageEngineFactory;
    private Database defaultDatabase;
    private StandaloneDatabaseContext defaultContext;

    DbmsDiagnosticsManagerTest() {
    }

    @BeforeEach
    void setUp() throws IOException {
        this.logProvider = new AssertableLogProvider();
        this.databaseManager = (DatabaseManager)Mockito.mock(DatabaseManager.class);
        this.storageEngine = (StorageEngine)Mockito.mock(StorageEngine.class);
        this.storageEngineFactory = (StorageEngineFactory)Mockito.mock(StorageEngineFactory.class);
        this.defaultContext = (StandaloneDatabaseContext)Mockito.mock(StandaloneDatabaseContext.class);
        this.defaultDatabase = this.prepareDatabase();
        Mockito.when((Object)this.storageEngineFactory.listStorageFiles((FileSystemAbstraction)ArgumentMatchers.any(), (DatabaseLayout)ArgumentMatchers.any())).thenReturn(Collections.emptyList());
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependency((Object)Config.defaults());
        dependencies.satisfyDependency(this.databaseManager);
        Mockito.when((Object)this.defaultContext.database()).thenReturn((Object)this.defaultDatabase);
        Mockito.when((Object)this.databaseManager.getDatabaseContext(DEFAULT_DATABASE_ID)).thenReturn(Optional.of(this.defaultContext));
        Mockito.when((Object)this.databaseManager.registeredDatabases()).thenReturn(new TreeMap<NamedDatabaseId, StandaloneDatabaseContext>(Collections.singletonMap(DEFAULT_DATABASE_ID, this.defaultContext)));
        this.diagnosticsManager = new DbmsDiagnosticsManager(dependencies, (LogService)new SimpleLogService((LogProvider)this.logProvider));
    }

    @Test
    void dumpSystemDiagnostics() {
        this.logProvider.assertNoLoggingOccurred();
        this.diagnosticsManager.dumpSystemDiagnostics();
        this.assertContainsSystemDiagnostics();
    }

    @Test
    void dumpDatabaseDiagnostics() {
        this.logProvider.assertNoLoggingOccurred();
        this.diagnosticsManager.dumpDatabaseDiagnostics(this.defaultDatabase);
        this.assertContainsDatabaseDiagnostics();
    }

    @Test
    void dumpDiagnosticOfStoppedDatabase() {
        Mockito.when((Object)this.defaultDatabase.isStarted()).thenReturn((Object)false);
        this.logProvider.assertNoLoggingOccurred();
        this.diagnosticsManager.dumpAll();
        this.logProvider.formattedMessageMatcher().assertContains("Database: " + DEFAULT_DATABASE_NAME.toLowerCase());
        this.logProvider.formattedMessageMatcher().assertContains("Database is stopped.");
    }

    @Test
    void dumpDiagnosticsInConciseForm() {
        HashMap<NamedDatabaseId, StandaloneDatabaseContext> databaseMap = new HashMap<NamedDatabaseId, StandaloneDatabaseContext>();
        int numberOfDatabases = 1000;
        for (int i = 0; i < numberOfDatabases; ++i) {
            Database database = (Database)Mockito.mock(Database.class);
            NamedDatabaseId namedDatabaseId = TestDatabaseIdRepository.randomNamedDatabaseId();
            Mockito.when((Object)database.getNamedDatabaseId()).thenReturn((Object)namedDatabaseId);
            databaseMap.put(namedDatabaseId, new StandaloneDatabaseContext(database));
        }
        Mockito.when((Object)this.databaseManager.registeredDatabases()).thenReturn(new TreeMap(databaseMap));
        this.diagnosticsManager.dumpAll();
        for (NamedDatabaseId dbId : databaseMap.keySet()) {
            this.logProvider.formattedMessageMatcher().assertContains("Database: " + dbId.name());
        }
    }

    @Test
    @EnabledOnOs(value={OS.LINUX})
    void dumpNativeAccessProviderOnLinux() {
        this.diagnosticsManager.dumpAll();
        this.logProvider.rawMessageMatcher().assertContains("Linux native access is available.");
    }

    @Test
    @DisabledOnOs(value={OS.LINUX})
    void dumpNativeAccessProviderOnNonLinux() {
        this.diagnosticsManager.dumpAll();
        this.logProvider.rawMessageMatcher().assertContains("Native access is not available for current platform.");
    }

    @Test
    void dumpAllDiagnostics() {
        this.logProvider.assertNoLoggingOccurred();
        this.diagnosticsManager.dumpAll();
        this.assertContainsSystemDiagnostics();
        this.assertContainsDatabaseDiagnostics();
    }

    private void assertContainsSystemDiagnostics() {
        this.logProvider.rawMessageMatcher().assertContains("System diagnostics");
        this.logProvider.rawMessageMatcher().assertContains("System memory information");
        this.logProvider.rawMessageMatcher().assertContains("JVM memory information");
        this.logProvider.rawMessageMatcher().assertContains("(IANA) TimeZone database version");
        this.logProvider.rawMessageMatcher().assertContains("Operating system information");
        this.logProvider.rawMessageMatcher().assertContains("System properties");
        this.logProvider.rawMessageMatcher().assertContains("JVM information");
        this.logProvider.rawMessageMatcher().assertContains("Java classpath");
        this.logProvider.rawMessageMatcher().assertContains("Library path");
        this.logProvider.rawMessageMatcher().assertContains("Network information");
        this.logProvider.rawMessageMatcher().assertContains("DBMS config");
    }

    private void assertContainsDatabaseDiagnostics() {
        this.logProvider.rawMessageMatcher().assertContains("Database: " + DEFAULT_DATABASE_NAME.toLowerCase());
        this.logProvider.rawMessageMatcher().assertContains("Version");
        this.logProvider.rawMessageMatcher().assertContains("Store files");
        this.logProvider.rawMessageMatcher().assertContains("Transaction log");
    }

    private Database prepareDatabase() {
        Database database = (Database)Mockito.mock(Database.class);
        Dependencies databaseDependencies = new Dependencies();
        databaseDependencies.satisfyDependency((Object)DatabaseInfo.COMMUNITY);
        databaseDependencies.satisfyDependency((Object)this.storageEngine);
        databaseDependencies.satisfyDependency((Object)this.storageEngineFactory);
        databaseDependencies.satisfyDependency((Object)new DefaultFileSystemAbstraction());
        Mockito.when((Object)database.getDependencyResolver()).thenReturn((Object)databaseDependencies);
        Mockito.when((Object)database.getNamedDatabaseId()).thenReturn((Object)DEFAULT_DATABASE_ID);
        Mockito.when((Object)database.isStarted()).thenReturn((Object)true);
        return database;
    }
}

