/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.impl.api.DatabaseSchemaState;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;

class DatabaseSchemaStateTest {
    private final AssertableLogProvider logProvider = new AssertableLogProvider();
    private DatabaseSchemaState stateStore;

    DatabaseSchemaStateTest() {
    }

    @BeforeEach
    void before() {
        this.stateStore = new DatabaseSchemaState((LogProvider)this.logProvider);
    }

    @Test
    void should_apply_updates_correctly() {
        this.stateStore.put((Object)"key", (Object)"created_value");
        String result = (String)this.stateStore.get((Object)"key");
        Assertions.assertEquals((Object)"created_value", (Object)result);
    }

    @Test
    void should_flush() {
        this.stateStore.put((Object)"key", (Object)"created_value");
        this.stateStore.clear();
        String result = (String)this.stateStore.get((Object)"key");
        Assertions.assertNull((Object)result);
        this.logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(DatabaseSchemaState.class).debug("Schema state store has been cleared.")});
    }
}

