/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.collection.Dependencies;
import org.neo4j.collection.pool.Pool;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.internal.index.label.LabelScanStore;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.availability.AvailabilityGuard;
import org.neo4j.kernel.database.TestDatabaseIdRepository;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.LeaseService;
import org.neo4j.kernel.impl.api.TestCommand;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionHeaderInformation;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.constraints.StandardConstraintSemantics;
import org.neo4j.kernel.impl.factory.AccessCapability;
import org.neo4j.kernel.impl.factory.CanWrite;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.NoOpClient;
import org.neo4j.kernel.impl.locking.SimpleStatementLocks;
import org.neo4j.kernel.impl.locking.StatementLocks;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionTracer;
import org.neo4j.kernel.impl.util.collection.CollectionsFactory;
import org.neo4j.kernel.impl.util.collection.OnHeapCollectionsFactory;
import org.neo4j.kernel.impl.util.diffsets.MutableLongDiffSetsImpl;
import org.neo4j.kernel.internal.event.DatabaseTransactionEventListeners;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceLocker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.resources.CpuClock;
import org.neo4j.resources.HeapAllocation;
import org.neo4j.storageengine.api.CommandCreationContext;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.values.storable.Value;

class KernelTransactionTestBase {
    protected final StorageEngine storageEngine = (StorageEngine)Mockito.mock(StorageEngine.class);
    protected final StorageReader storageReader = (StorageReader)Mockito.mock(StorageReader.class);
    protected final TransactionIdStore transactionIdStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
    protected final CommandCreationContext commandCreationContext = (CommandCreationContext)Mockito.mock(CommandCreationContext.class);
    protected final TransactionMonitor transactionMonitor = (TransactionMonitor)Mockito.mock(TransactionMonitor.class);
    protected final CapturingCommitProcess commitProcess = new CapturingCommitProcess();
    protected final TransactionHeaderInformation headerInformation = (TransactionHeaderInformation)Mockito.mock(TransactionHeaderInformation.class);
    protected final AvailabilityGuard availabilityGuard = (AvailabilityGuard)Mockito.mock(AvailabilityGuard.class);
    protected final FakeClock clock = Clocks.fakeClock();
    protected final Pool<KernelTransactionImplementation> txPool = (Pool)Mockito.mock(Pool.class);
    protected CollectionsFactory collectionsFactory;
    protected final Config config = Config.defaults();
    private final long defaultTransactionTimeoutMillis = ((Duration)this.config.get(GraphDatabaseSettings.transaction_timeout)).toMillis();

    KernelTransactionTestBase() {
    }

    @BeforeEach
    public void before() throws Exception {
        this.collectionsFactory = (CollectionsFactory)Mockito.spy((Object)new TestCollectionsFactory());
        Mockito.when((Object)this.headerInformation.getAdditionalHeader()).thenReturn((Object)new byte[0]);
        Mockito.when((Object)this.storageEngine.newReader()).thenReturn((Object)this.storageReader);
        Mockito.when((Object)this.storageEngine.newCommandCreationContext()).thenReturn((Object)this.commandCreationContext);
        Mockito.when((Object)this.storageEngine.transactionIdStore()).thenReturn((Object)this.transactionIdStore);
        ((StorageEngine)Mockito.doAnswer(invocation -> ((Collection)invocation.getArgument(0)).add(new TestCommand())).when((Object)this.storageEngine)).createCommands(ArgumentMatchers.anyCollection(), (ReadableTransactionState)ArgumentMatchers.any(ReadableTransactionState.class), (StorageReader)ArgumentMatchers.any(StorageReader.class), (CommandCreationContext)ArgumentMatchers.any(CommandCreationContext.class), (ResourceLocker)ArgumentMatchers.any(ResourceLocker.class), ArgumentMatchers.anyLong(), (TxStateVisitor.Decorator)ArgumentMatchers.any(TxStateVisitor.Decorator.class));
    }

    public KernelTransactionImplementation newTransaction(long transactionTimeoutMillis) {
        return this.newTransaction(0L, LoginContext.AUTH_DISABLED, transactionTimeoutMillis);
    }

    public KernelTransactionImplementation newTransaction(LoginContext loginContext) {
        return this.newTransaction(0L, loginContext);
    }

    public KernelTransactionImplementation newTransaction(LoginContext loginContext, Locks.Client locks) {
        return this.newTransaction(0L, loginContext, locks, this.defaultTransactionTimeoutMillis);
    }

    public KernelTransactionImplementation newTransaction(long lastTransactionIdWhenStarted, LoginContext loginContext) {
        return this.newTransaction(lastTransactionIdWhenStarted, loginContext, this.defaultTransactionTimeoutMillis);
    }

    public KernelTransactionImplementation newTransaction(long lastTransactionIdWhenStarted, LoginContext loginContext, long transactionTimeoutMillis) {
        return this.newTransaction(lastTransactionIdWhenStarted, loginContext, (Locks.Client)new NoOpClient(), transactionTimeoutMillis);
    }

    public KernelTransactionImplementation newTransaction(long lastTransactionIdWhenStarted, LoginContext loginContext, Locks.Client locks, long transactionTimeout) {
        KernelTransactionImplementation tx = this.newNotInitializedTransaction();
        SimpleStatementLocks statementLocks = new SimpleStatementLocks(locks);
        SecurityContext securityContext = loginContext.authorize(LoginContext.IdLookup.EMPTY, "neo4j");
        tx.initialize(lastTransactionIdWhenStarted, 0L, (StatementLocks)statementLocks, KernelTransaction.Type.explicit, securityContext, transactionTimeout, 1L, ClientConnectionInfo.EMBEDDED_CONNECTION);
        return tx;
    }

    KernelTransactionImplementation newNotInitializedTransaction() {
        return this.newNotInitializedTransaction(LeaseService.NO_LEASES);
    }

    KernelTransactionImplementation newNotInitializedTransaction(LeaseService leaseService) {
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependency((Object)((GraphDatabaseFacade)Mockito.mock(GraphDatabaseFacade.class)));
        return new KernelTransactionImplementation(this.config, (DatabaseTransactionEventListeners)Mockito.mock(DatabaseTransactionEventListeners.class), null, null, (TransactionCommitProcess)this.commitProcess, this.transactionMonitor, this.txPool, (SystemNanoClock)this.clock, new AtomicReference<CpuClock>(CpuClock.NOT_AVAILABLE), new AtomicReference<HeapAllocation>(HeapAllocation.NOT_AVAILABLE), TransactionTracer.NULL, LockTracer.NONE, PageCursorTracerSupplier.NULL, this.storageEngine, (AccessCapability)new CanWrite(), EmptyVersionContextSupplier.EMPTY, () -> this.collectionsFactory, (ConstraintSemantics)new StandardConstraintSemantics(), (SchemaState)Mockito.mock(SchemaState.class), DatabaseRule.mockedTokenHolders(), (IndexingService)Mockito.mock(IndexingService.class), (LabelScanStore)Mockito.mock(LabelScanStore.class), (IndexStatisticsStore)Mockito.mock(IndexStatisticsStore.class), dependencies, new TestDatabaseIdRepository().defaultDatabase(), leaseService);
    }

    private static class TestCollectionsFactory
    implements CollectionsFactory {
        private TestCollectionsFactory() {
        }

        public MutableLongSet newLongSet() {
            return OnHeapCollectionsFactory.INSTANCE.newLongSet();
        }

        public MutableLongDiffSetsImpl newLongDiffSets() {
            return OnHeapCollectionsFactory.INSTANCE.newLongDiffSets();
        }

        public MutableLongObjectMap<Value> newValuesMap() {
            return new LongObjectHashMap();
        }

        public MemoryTracker getMemoryTracker() {
            return OnHeapCollectionsFactory.INSTANCE.getMemoryTracker();
        }

        public void release() {
        }
    }

    public static class CapturingCommitProcess
    implements TransactionCommitProcess {
        private long txId = 1L;
        public List<TransactionRepresentation> transactions = new ArrayList<TransactionRepresentation>();

        public long commit(TransactionToApply batch, CommitEvent commitEvent, TransactionApplicationMode mode) {
            this.transactions.add(batch.transactionRepresentation());
            return ++this.txId;
        }
    }
}

