/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.ContractCheckingIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxyAdapter;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.SchemaIndexTestHelper;
import org.neo4j.test.DoubleLatch;
import org.neo4j.test.ThreadTestUtils;

class ContractCheckingIndexProxyTest {
    private static final long TEST_TIMEOUT = 20000L;

    ContractCheckingIndexProxyTest() {
    }

    @Test
    void shouldNotCreateIndexTwice() {
        IndexProxy inner = SchemaIndexTestHelper.mockIndexProxy();
        ContractCheckingIndexProxy outer = ContractCheckingIndexProxyTest.newContractCheckingIndexProxy(inner);
        outer.start();
        Assertions.assertThrows(IllegalStateException.class, () -> ((IndexProxy)outer).start());
    }

    @Test
    void shouldNotCloseIndexTwice() throws IOException {
        IndexProxy inner = SchemaIndexTestHelper.mockIndexProxy();
        ContractCheckingIndexProxy outer = ContractCheckingIndexProxyTest.newContractCheckingIndexProxy(inner);
        outer.close();
        Assertions.assertThrows(IllegalStateException.class, () -> ((IndexProxy)outer).close());
    }

    @Test
    void shouldNotDropIndexTwice() {
        IndexProxy inner = SchemaIndexTestHelper.mockIndexProxy();
        ContractCheckingIndexProxy outer = ContractCheckingIndexProxyTest.newContractCheckingIndexProxy(inner);
        outer.drop();
        Assertions.assertThrows(IllegalStateException.class, () -> ((IndexProxy)outer).drop());
    }

    @Test
    void shouldNotDropAfterClose() throws IOException {
        IndexProxy inner = SchemaIndexTestHelper.mockIndexProxy();
        ContractCheckingIndexProxy outer = ContractCheckingIndexProxyTest.newContractCheckingIndexProxy(inner);
        outer.close();
        Assertions.assertThrows(IllegalStateException.class, () -> ((IndexProxy)outer).drop());
    }

    @Test
    void shouldDropAfterCreate() {
        IndexProxy inner = SchemaIndexTestHelper.mockIndexProxy();
        ContractCheckingIndexProxy outer = ContractCheckingIndexProxyTest.newContractCheckingIndexProxy(inner);
        outer.start();
        outer.drop();
    }

    @Test
    void shouldCloseAfterCreate() throws IOException {
        IndexProxy inner = SchemaIndexTestHelper.mockIndexProxy();
        ContractCheckingIndexProxy outer = ContractCheckingIndexProxyTest.newContractCheckingIndexProxy(inner);
        outer.start();
        outer.close();
    }

    @Test
    void shouldNotUpdateBeforeCreate() {
        IndexProxy inner = SchemaIndexTestHelper.mockIndexProxy();
        ContractCheckingIndexProxy outer = ContractCheckingIndexProxyTest.newContractCheckingIndexProxy(inner);
        Assertions.assertThrows(IllegalStateException.class, () -> ContractCheckingIndexProxyTest.lambda$shouldNotUpdateBeforeCreate$0((IndexProxy)outer));
    }

    @Test
    void shouldNotUpdateAfterClose() throws Exception {
        IndexProxy inner = SchemaIndexTestHelper.mockIndexProxy();
        ContractCheckingIndexProxy outer = ContractCheckingIndexProxyTest.newContractCheckingIndexProxy(inner);
        outer.start();
        outer.close();
        Assertions.assertThrows(IllegalStateException.class, () -> ContractCheckingIndexProxyTest.lambda$shouldNotUpdateAfterClose$1((IndexProxy)outer));
    }

    @Test
    void shouldNotForceBeforeCreate() {
        IndexProxy inner = SchemaIndexTestHelper.mockIndexProxy();
        ContractCheckingIndexProxy outer = ContractCheckingIndexProxyTest.newContractCheckingIndexProxy(inner);
        Assertions.assertThrows(IllegalStateException.class, () -> ContractCheckingIndexProxyTest.lambda$shouldNotForceBeforeCreate$2((IndexProxy)outer));
    }

    @Test
    void shouldNotForceAfterClose() throws IOException {
        IndexProxy inner = SchemaIndexTestHelper.mockIndexProxy();
        ContractCheckingIndexProxy outer = ContractCheckingIndexProxyTest.newContractCheckingIndexProxy(inner);
        outer.start();
        outer.close();
        Assertions.assertThrows(IllegalStateException.class, () -> ContractCheckingIndexProxyTest.lambda$shouldNotForceAfterClose$3((IndexProxy)outer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldNotCloseWhileCreating() {
        final DoubleLatch latch = new DoubleLatch();
        IndexProxyAdapter inner = new IndexProxyAdapter(){

            @Override
            public void start() {
                latch.startAndWaitForAllToStartAndFinish();
            }
        };
        ContractCheckingIndexProxy outer = ContractCheckingIndexProxyTest.newContractCheckingIndexProxy(inner);
        ContractCheckingIndexProxyTest.runInSeparateThread(() -> ((IndexProxy)outer).start());
        try {
            latch.waitForAllToStart();
            Assertions.assertThrows(IllegalStateException.class, () -> ((IndexProxy)outer).close());
        }
        finally {
            latch.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldNotDropWhileCreating() {
        final DoubleLatch latch = new DoubleLatch();
        IndexProxyAdapter inner = new IndexProxyAdapter(){

            @Override
            public void start() {
                latch.startAndWaitForAllToStartAndFinish();
            }
        };
        ContractCheckingIndexProxy outer = ContractCheckingIndexProxyTest.newContractCheckingIndexProxy(inner);
        ContractCheckingIndexProxyTest.runInSeparateThread(() -> ((IndexProxy)outer).start());
        try {
            latch.waitForAllToStart();
            Assertions.assertThrows(IllegalStateException.class, () -> ((IndexProxy)outer).drop());
        }
        finally {
            latch.finish();
        }
    }

    @Test
    void closeWaitForUpdateToFinish() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        IndexProxyAdapter inner = new IndexProxyAdapter(){

            @Override
            public IndexUpdater newUpdater(IndexUpdateMode mode) {
                return super.newUpdater(mode);
            }
        };
        ContractCheckingIndexProxy outer = ContractCheckingIndexProxyTest.newContractCheckingIndexProxy(inner);
        Thread actionThread = ContractCheckingIndexProxyTest.createActionThread(() -> ((IndexProxy)outer).close());
        outer.start();
        Thread updaterThread = ContractCheckingIndexProxyTest.runInSeparateThread(() -> ContractCheckingIndexProxyTest.lambda$closeWaitForUpdateToFinish$4((IndexProxy)outer, actionThread, latch));
        ThreadTestUtils.awaitThreadState((Thread)actionThread, (long)20000L, (Thread.State)Thread.State.TIMED_WAITING, (Thread.State[])new Thread.State[0]);
        latch.countDown();
        updaterThread.join();
        actionThread.join();
    }

    @Test
    void closeWaitForForceToComplete() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference<Thread> actionThreadReference = new AtomicReference<Thread>();
        IndexProxyAdapter inner = new IndexProxyAdapter(){

            @Override
            public void force(IOLimiter ioLimiter) {
                try {
                    ((Thread)actionThreadReference.get()).start();
                    latch.await();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        ContractCheckingIndexProxy outer = ContractCheckingIndexProxyTest.newContractCheckingIndexProxy(inner);
        Thread actionThread = ContractCheckingIndexProxyTest.createActionThread(() -> ((IndexProxy)outer).close());
        actionThreadReference.set(actionThread);
        outer.start();
        Thread thread = ContractCheckingIndexProxyTest.runInSeparateThread(() -> ContractCheckingIndexProxyTest.lambda$closeWaitForForceToComplete$5((IndexProxy)outer));
        ThreadTestUtils.awaitThreadState((Thread)actionThread, (long)20000L, (Thread.State)Thread.State.TIMED_WAITING, (Thread.State[])new Thread.State[0]);
        latch.countDown();
        thread.join();
        actionThread.join();
    }

    private static Thread runInSeparateThread(ThrowingRunnable action) {
        Thread thread = ContractCheckingIndexProxyTest.createActionThread(action);
        thread.start();
        return thread;
    }

    private static Thread createActionThread(ThrowingRunnable action) {
        return new Thread(() -> {
            try {
                action.run();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static ContractCheckingIndexProxy newContractCheckingIndexProxy(IndexProxy inner) {
        return new ContractCheckingIndexProxy(inner, false);
    }

    private static /* synthetic */ void lambda$closeWaitForForceToComplete$5(IndexProxy outer) throws IOException {
        outer.force(IOLimiter.UNLIMITED);
    }

    private static /* synthetic */ void lambda$closeWaitForUpdateToFinish$4(IndexProxy outer, Thread actionThread, CountDownLatch latch) throws IOException {
        try (IndexUpdater updater = outer.newUpdater(IndexUpdateMode.ONLINE);){
            updater.process(null);
            try {
                actionThread.start();
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        catch (IndexEntryConflictException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void lambda$shouldNotForceAfterClose$3(IndexProxy outer) throws Throwable {
        outer.force(IOLimiter.UNLIMITED);
    }

    private static /* synthetic */ void lambda$shouldNotForceBeforeCreate$2(IndexProxy outer) throws Throwable {
        outer.force(IOLimiter.UNLIMITED);
    }

    private static /* synthetic */ void lambda$shouldNotUpdateAfterClose$1(IndexProxy outer) throws Throwable {
        try (IndexUpdater updater = outer.newUpdater(IndexUpdateMode.ONLINE);){
            updater.process(null);
        }
    }

    private static /* synthetic */ void lambda$shouldNotUpdateBeforeCreate$0(IndexProxy outer) throws Throwable {
        try (IndexUpdater updater = outer.newUpdater(IndexUpdateMode.ONLINE);){
            updater.process(null);
        }
    }

    private static interface ThrowingRunnable {
        public void run() throws IOException;
    }
}

