/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.stats;

import java.io.File;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.function.Function;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.TreeFileNotFoundException;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;
import org.neo4j.test.Race;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.pagecache.EphemeralPageCacheExtension;
import org.neo4j.test.rule.TestDirectory;

@EphemeralPageCacheExtension
class IndexStatisticsStoreTest {
    private LifeSupport lifeSupport = new LifeSupport();
    @Inject
    private PageCache pageCache;
    @Inject
    private TestDirectory testDirectory;
    private IndexStatisticsStore store;

    IndexStatisticsStoreTest() {
    }

    @BeforeEach
    void start() {
        this.store = this.openStore();
        this.lifeSupport.start();
    }

    @AfterEach
    void stop() {
        this.lifeSupport.shutdown();
    }

    private IndexStatisticsStore openStore() {
        return (IndexStatisticsStore)this.lifeSupport.add((Lifecycle)new IndexStatisticsStore(this.pageCache, this.testDirectory.file("stats", new String[0]), RecoveryCleanupWorkCollector.immediate(), false));
    }

    @Test
    void shouldReplaceIndexSample() {
        long indexId = 4L;
        this.store.replaceStats(indexId, 123L, 456L, 0L, 0L);
        IndexStatisticsStoreTest.assertRegister(123L, 456L, this.store.indexSample(indexId, Registers.newDoubleLongRegister()));
        this.store.replaceStats(indexId, 444L, 555L, 0L, 0L);
        IndexStatisticsStoreTest.assertRegister(444L, 555L, this.store.indexSample(indexId, Registers.newDoubleLongRegister()));
    }

    @Test
    void shouldReplaceIndexStatistics() {
        long indexId = 4L;
        this.store.replaceStats(indexId, 0L, 0L, 123L, 456L);
        IndexStatisticsStoreTest.assertRegister(123L, 456L, this.store.indexUpdatesAndSize(indexId, Registers.newDoubleLongRegister()));
        this.store.replaceStats(indexId, 0L, 0L, 444L, 555L);
        IndexStatisticsStoreTest.assertRegister(444L, 555L, this.store.indexUpdatesAndSize(indexId, Registers.newDoubleLongRegister()));
    }

    @Test
    void shouldIncrementIndexUpdates() {
        long indexId = 4L;
        this.store.replaceStats(indexId, 0L, 0L, 123L, 456L);
        this.store.incrementIndexUpdates(indexId, 5L);
        IndexStatisticsStoreTest.assertRegister(128L, 456L, this.store.indexUpdatesAndSize(indexId, Registers.newDoubleLongRegister()));
    }

    @Test
    void shouldStoreDataOnCheckpoint() throws IOException {
        long indexId1 = 1L;
        long indexId2 = 2L;
        this.store.replaceStats(indexId1, 100L, 200L, 15L, 20L);
        this.store.replaceStats(indexId2, 200L, 300L, 25L, 35L);
        this.restartStore();
        IndexStatisticsStoreTest.assertRegister(15L, 20L, this.store.indexUpdatesAndSize(indexId1, Registers.newDoubleLongRegister()));
        IndexStatisticsStoreTest.assertRegister(25L, 35L, this.store.indexUpdatesAndSize(indexId2, Registers.newDoubleLongRegister()));
        IndexStatisticsStoreTest.assertRegister(100L, 200L, this.store.indexSample(indexId1, Registers.newDoubleLongRegister()));
        IndexStatisticsStoreTest.assertRegister(200L, 300L, this.store.indexSample(indexId2, Registers.newDoubleLongRegister()));
    }

    private void restartStore() throws IOException {
        this.store.checkpoint(IOLimiter.UNLIMITED);
        this.lifeSupport.shutdown();
        this.lifeSupport = new LifeSupport();
        this.store = this.openStore();
        this.lifeSupport.start();
    }

    @Test
    void shouldAllowMultipleThreadsIncrementIndexUpdates() throws Throwable {
        long indexId = 5L;
        Race race = new Race();
        int contestants = 20;
        int delta = 3;
        this.store.replaceStats(indexId, 0L, 0L, 0L);
        race.addContestants(contestants, () -> this.store.incrementIndexUpdates(indexId, (long)delta), 1);
        race.go();
        IndexStatisticsStoreTest.assertRegister(contestants * delta, 0L, this.store.indexUpdatesAndSize(indexId, Registers.newDoubleLongRegister()));
    }

    @Test
    void shouldHandleConcurrentUpdatesWithCheckpointing() throws Throwable {
        Race race = new Race();
        AtomicBoolean checkpointDone = new AtomicBoolean();
        int contestantsPerIndex = 5;
        int indexes = 3;
        int delta = 5;
        AtomicIntegerArray expected = new AtomicIntegerArray(indexes);
        race.addContestant(Race.throwing(() -> {
            for (int i = 0; i < 20; ++i) {
                Thread.sleep(5L);
                this.store.checkpoint(IOLimiter.UNLIMITED);
            }
            checkpointDone.set(true);
        }));
        int i = 0;
        while (i < indexes) {
            int indexId = i++;
            this.store.replaceStats((long)indexId, 0L, 0L, 0L);
            race.addContestants(contestantsPerIndex, () -> {
                while (!checkpointDone.get()) {
                    this.store.incrementIndexUpdates((long)indexId, (long)delta);
                    expected.addAndGet(indexId, delta);
                }
            });
        }
        race.go();
        for (i = 0; i < indexes; ++i) {
            IndexStatisticsStoreTest.assertRegister(expected.get(i), 0L, this.store.indexUpdatesAndSize((long)i, Registers.newDoubleLongRegister()));
        }
        this.restartStore();
        for (i = 0; i < indexes; ++i) {
            IndexStatisticsStoreTest.assertRegister(expected.get(i), 0L, this.store.indexUpdatesAndSize((long)i, Registers.newDoubleLongRegister()));
        }
    }

    @Test
    void shouldNotStartWithoutFileIfReadOnly() {
        IndexStatisticsStore indexStatisticsStore = new IndexStatisticsStore(this.pageCache, this.testDirectory.file("non-existing", new String[0]), RecoveryCleanupWorkCollector.immediate(), true);
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> ((IndexStatisticsStore)indexStatisticsStore).init());
        Assertions.assertTrue((boolean)Exceptions.contains((Throwable)e, t -> t instanceof NoSuchFileException));
        Assertions.assertTrue((boolean)Exceptions.contains((Throwable)e, t -> t instanceof TreeFileNotFoundException));
        Assertions.assertTrue((boolean)Exceptions.contains((Throwable)e, t -> t instanceof IllegalStateException));
    }

    @Test
    void shouldNotReplaceStatsIfReadOnly() throws IOException {
        this.assertOperationThrowInReadOnlyMode(iss -> () -> iss.replaceStats(1L, 1L, 1L, 1L));
    }

    @Test
    void shouldNotRemoveIndexIfReadOnly() throws IOException {
        this.assertOperationThrowInReadOnlyMode(iss -> () -> iss.removeIndex(1L));
    }

    @Test
    void shouldNotIncrementIndexUpdatesIfReadOnly() throws IOException {
        this.assertOperationThrowInReadOnlyMode(iss -> () -> iss.incrementIndexUpdates(1L, 1L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertOperationThrowInReadOnlyMode(Function<IndexStatisticsStore, Executable> operation) throws IOException {
        File file = this.testDirectory.file("existing", new String[0]);
        IndexStatisticsStore store = new IndexStatisticsStore(this.pageCache, file, RecoveryCleanupWorkCollector.immediate(), false);
        try {
            store.init();
        }
        finally {
            store.shutdown();
        }
        IndexStatisticsStore readOnlyStore = new IndexStatisticsStore(this.pageCache, file, RecoveryCleanupWorkCollector.immediate(), true);
        try {
            readOnlyStore.init();
            UnsupportedOperationException e = (UnsupportedOperationException)Assertions.assertThrows(UnsupportedOperationException.class, (Executable)operation.apply(readOnlyStore));
            Assertions.assertEquals((Object)"Can not write to index statistics store while in read only mode.", (Object)e.getMessage());
        }
        finally {
            readOnlyStore.shutdown();
        }
    }

    private static void assertRegister(long first, long second, Register.DoubleLongRegister register) {
        Assertions.assertEquals((long)first, (long)register.readFirst());
        Assertions.assertEquals((long)second, (long)register.readSecond());
    }
}

