/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.config;

import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.kernel.impl.index.schema.config.ConfiguredSpaceFillingCurveSettingsCache;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettings;
import org.neo4j.kernel.impl.index.schema.config.ToMapSettingVisitor;
import org.neo4j.values.storable.CoordinateReferenceSystem;

class IndexSpecificSpaceFillingCurveSettingsTest {
    private static final Config config = Config.defaults();
    private final ConfiguredSpaceFillingCurveSettingsCache globalSettings = new ConfiguredSpaceFillingCurveSettingsCache(config);

    IndexSpecificSpaceFillingCurveSettingsTest() {
    }

    @Test
    void shouldHaveInitialIndexSpecificSetting() {
        HashMap<CoordinateReferenceSystem, SpaceFillingCurveSettings> initialSettings = new HashMap<CoordinateReferenceSystem, SpaceFillingCurveSettings>();
        initialSettings.put(CoordinateReferenceSystem.WGS84, this.globalSettings.forCRS(CoordinateReferenceSystem.WGS84));
        initialSettings.put(CoordinateReferenceSystem.Cartesian, this.globalSettings.forCRS(CoordinateReferenceSystem.Cartesian));
        IndexSpecificSpaceFillingCurveSettings indexSettings = new IndexSpecificSpaceFillingCurveSettings(initialSettings);
        ToMapSettingVisitor visitor = new ToMapSettingVisitor();
        indexSettings.visitIndexSpecificSettings((IndexSpecificSpaceFillingCurveSettings.SettingVisitor)visitor);
        Assertions.assertEquals(initialSettings, visitor.map);
    }

    @Test
    void shouldThrowIfAskedForNonExistingIndexSetting() {
        HashMap<CoordinateReferenceSystem, SpaceFillingCurveSettings> initialSettings = new HashMap<CoordinateReferenceSystem, SpaceFillingCurveSettings>();
        initialSettings.put(CoordinateReferenceSystem.WGS84, this.globalSettings.forCRS(CoordinateReferenceSystem.WGS84));
        initialSettings.put(CoordinateReferenceSystem.Cartesian, this.globalSettings.forCRS(CoordinateReferenceSystem.Cartesian));
        IndexSpecificSpaceFillingCurveSettings indexSettings = new IndexSpecificSpaceFillingCurveSettings(initialSettings);
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> indexSettings.forCrs(CoordinateReferenceSystem.Cartesian_3D));
        Assertions.assertTrue((boolean)exception.getMessage().contains("Index does not have any settings for coordinate reference system cartesian-3d"));
    }
}

