/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import org.eclipse.collections.impl.map.mutable.primitive.LongLongHashMap;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.impl.locking.ResourceIds;

class ResourceTypesIT {
    ResourceTypesIT() {
    }

    @Test
    void indexEntryHashing() {
        int collisions = 0;
        int labelIdCount = 50;
        int propertyKeyIdCount = 50;
        int objectCount = 10000;
        LongLongHashMap map = new LongLongHashMap(25000000);
        String[] values = ResourceTypesIT.precomputeValues(objectCount);
        for (int labelId = 0; labelId < labelIdCount; ++labelId) {
            for (int propertyKeyId = 0; propertyKeyId < propertyKeyIdCount; ++propertyKeyId) {
                for (int objectId = 0; objectId < objectCount; ++objectId) {
                    String object = values[objectId];
                    long resourceId = ResourceIds.indexEntryResourceId((long)labelId, (IndexQuery.ExactPredicate[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)propertyKeyId, (Object)object)});
                    long newValue = ResourceTypesIT.packValue(labelId, propertyKeyId, objectId);
                    boolean hasOldValue = map.containsKey(resourceId);
                    long oldValue = map.get(resourceId);
                    map.put(resourceId, newValue);
                    if (!hasOldValue) continue;
                    System.out.printf("Collision on %s: %s ~= %s%n", resourceId, ResourceTypesIT.toValueString(newValue), ResourceTypesIT.toValueString(oldValue));
                    if (++collisions <= 100) continue;
                    Assertions.fail((String)"This hashing is terrible!");
                }
            }
        }
        MatcherAssert.assertThat((Object)collisions, (Matcher)Matchers.is((Object)0));
    }

    private static long packValue(int labelId, int propertyKeyId, int objectId) {
        long result = labelId;
        result <<= 16;
        result += (long)propertyKeyId;
        result <<= 32;
        return result += (long)objectId;
    }

    private static String toValueString(long value) {
        int objectId = (int)(value & 0xFFFFFFFFL);
        int propertyKeyId = (int)((value & 0xFFFF00000000L) >>> 32);
        int labelId = (int)((value & 0xFFFF000000000000L) >>> 48);
        return String.format("IndexEntry{ labelId=%s, propertyKeyId=%s, objectId=%s }", labelId, propertyKeyId, objectId);
    }

    private static String[] precomputeValues(int objectCount) {
        String[] values = new String[objectCount];
        for (int i = 0; i < objectCount; ++i) {
            values[i] = String.valueOf(i);
        }
        return values;
    }
}

