/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.helpers.StubNodeCursor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.impl.newapi.NodeSchemaMatcher;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;

class NodeSchemaMatcherTest {
    private static final int labelId1 = 10;
    private static final int nonExistentLabelId = 12;
    private static final int propId1 = 20;
    private static final int propId2 = 21;
    private static final int unIndexedPropId = 22;
    private static final int nonExistentPropId = 23;
    private static final int specialPropId = 24;
    private static final int[] props = new int[]{20, 21, 22};
    private final IndexDescriptor index1 = TestIndexDescriptorFactory.forLabel(10, 20);
    private final IndexDescriptor index1_2 = TestIndexDescriptorFactory.forLabel(10, 20, 21);
    private final IndexDescriptor indexWithMissingProperty = TestIndexDescriptorFactory.forLabel(10, 20, 23);
    private final IndexDescriptor indexWithMissingLabel = TestIndexDescriptorFactory.forLabel(12, 20, 21);
    private final IndexDescriptor indexOnSpecialProperty = TestIndexDescriptorFactory.forLabel(10, 20, 24);
    private StubNodeCursor node;

    NodeSchemaMatcherTest() {
    }

    @BeforeEach
    void setup() {
        HashMap<Integer, TextValue> map = new HashMap<Integer, TextValue>();
        map.put(20, Values.stringValue((String)"hello"));
        map.put(21, Values.stringValue((String)"world"));
        map.put(22, Values.stringValue((String)"!"));
        this.node = new StubNodeCursor(false);
        this.node.withNode(42L, new long[]{10L}, map);
        this.node.next();
    }

    @Test
    void shouldMatchOnSingleProperty() {
        ArrayList matched = new ArrayList();
        NodeSchemaMatcher.onMatchingSchema((Iterator)Iterators.iterator((Object)this.index1), (int)22, (int[])props, matched::add);
        MatcherAssert.assertThat(matched, (Matcher)Matchers.contains((Object[])new IndexDescriptor[]{this.index1}));
    }

    @Test
    void shouldMatchOnTwoProperties() {
        ArrayList matched = new ArrayList();
        NodeSchemaMatcher.onMatchingSchema((Iterator)Iterators.iterator((Object)this.index1_2), (int)22, (int[])props, matched::add);
        MatcherAssert.assertThat(matched, (Matcher)Matchers.contains((Object[])new IndexDescriptor[]{this.index1_2}));
    }

    @Test
    void shouldNotMatchIfNodeIsMissingProperty() {
        ArrayList matched = new ArrayList();
        NodeSchemaMatcher.onMatchingSchema((Iterator)Iterators.iterator((Object)this.indexWithMissingProperty), (int)22, (int[])props, matched::add);
        MatcherAssert.assertThat(matched, (Matcher)Matchers.empty());
    }

    @Test
    void shouldNotMatchIfNodeIsMissingLabel() {
        ArrayList matched = new ArrayList();
        NodeSchemaMatcher.onMatchingSchema((Iterator)Iterators.iterator((Object)this.indexWithMissingLabel), (long[])this.node.labels().all(), (int)22, (int[])props, matched::add);
        MatcherAssert.assertThat(matched, (Matcher)Matchers.empty());
    }

    @Test
    void shouldMatchOnSpecialProperty() {
        ArrayList matched = new ArrayList();
        NodeSchemaMatcher.onMatchingSchema((Iterator)Iterators.iterator((Object)this.indexOnSpecialProperty), (int)24, (int[])props, matched::add);
        MatcherAssert.assertThat(matched, (Matcher)Matchers.contains((Object[])new IndexDescriptor[]{this.indexOnSpecialProperty}));
    }

    @Test
    void shouldMatchSeveralTimes() {
        List<IndexDescriptor> indexes = Arrays.asList(this.index1, this.index1, this.index1_2, this.index1_2);
        ArrayList matched = new ArrayList();
        NodeSchemaMatcher.onMatchingSchema(indexes.iterator(), (int)22, (int[])props, matched::add);
        MatcherAssert.assertThat(matched, (Matcher)Matchers.equalTo(indexes));
    }
}

