/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.api.TestCommand;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.NoSuchTransactionException;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.storageengine.api.StorageCommand;

class TransactionPositionLocatorTest {
    private final LogEntryReader logEntryReader = (LogEntryReader)Mockito.mock(LogEntryReader.class);
    private final ReadableClosablePositionAwareChecksumChannel channel = (ReadableClosablePositionAwareChecksumChannel)Mockito.mock(ReadableClosablePositionAwareChecksumChannel.class);
    private final TransactionMetadataCache metadataCache = (TransactionMetadataCache)Mockito.mock(TransactionMetadataCache.class);
    private final long txId = 42L;
    private final LogPosition startPosition = new LogPosition(1L, 128L);
    private final LogEntryStart start = new LogEntryStart(0L, 0L, 0, null, this.startPosition);
    private final LogEntryCommand command = new LogEntryCommand((StorageCommand)new TestCommand());
    private final LogEntryCommit commit = new LogEntryCommit(42L, System.currentTimeMillis(), -559063315);

    TransactionPositionLocatorTest() {
    }

    @Test
    void shouldFindTransactionLogPosition() throws IOException {
        PhysicalLogicalTransactionStore.TransactionPositionLocator locator = new PhysicalLogicalTransactionStore.TransactionPositionLocator(42L, this.logEntryReader);
        Mockito.when((Object)this.logEntryReader.readLogEntry(this.channel)).thenReturn((Object)this.start, (Object[])new LogEntry[]{this.command, this.commit, null});
        boolean result = locator.visit(this.channel);
        LogPosition position = locator.getAndCacheFoundLogPosition(this.metadataCache);
        Assertions.assertFalse((boolean)result);
        Assertions.assertEquals((Object)this.startPosition, (Object)position);
        ((TransactionMetadataCache)Mockito.verify((Object)this.metadataCache)).cacheTransactionMetadata(42L, this.startPosition, this.commit.getChecksum(), this.commit.getTimeWritten());
    }

    @Test
    void shouldNotFindTransactionLogPosition() throws IOException {
        PhysicalLogicalTransactionStore.TransactionPositionLocator locator = new PhysicalLogicalTransactionStore.TransactionPositionLocator(42L, this.logEntryReader);
        Mockito.when((Object)this.logEntryReader.readLogEntry(this.channel)).thenReturn((Object)this.start, (Object[])new LogEntry[]{this.command, null});
        boolean result = locator.visit(this.channel);
        Assertions.assertTrue((boolean)result);
        NoSuchTransactionException exception = (NoSuchTransactionException)Assertions.assertThrows(NoSuchTransactionException.class, () -> locator.getAndCacheFoundLogPosition(this.metadataCache));
        Assertions.assertEquals((Object)"Unable to find transaction 42 in any of my logical logs", (Object)exception.getMessage());
    }
}

