/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.function.ThrowingAction;
import org.neo4j.graphdb.Resource;
import org.neo4j.kernel.impl.transaction.log.checkpoint.StoreCopyCheckPointMutex;
import org.neo4j.test.Barrier;
import org.neo4j.test.Race;
import org.neo4j.test.rule.OtherThreadRule;

class StoreCopyCheckPointMutexTest {
    private static final ThrowingAction<IOException> ASSERT_NOT_CALLED = () -> Assertions.fail((String)"Should not be called");
    private final OtherThreadRule<Void> t2 = new OtherThreadRule();
    private final OtherThreadRule<Void> t3 = new OtherThreadRule();
    private final StoreCopyCheckPointMutex mutex = new StoreCopyCheckPointMutex();

    StoreCopyCheckPointMutexTest() {
    }

    @BeforeEach
    void setUp() {
        this.t2.init("T2");
        this.t3.init("T3");
    }

    @AfterEach
    void tearDown() {
        this.t2.close();
        this.t3.close();
    }

    @Test
    void checkPointShouldBlockStoreCopy() throws Exception {
        try (Resource lock = this.mutex.checkPoint();){
            this.t2.execute(state -> this.mutex.storeCopy(ThrowingAction.noop()));
            this.t2.get().waitUntilWaiting(details -> details.isAt(StoreCopyCheckPointMutex.class, "storeCopy"));
        }
    }

    @Test
    void checkPointShouldBlockAnotherCheckPoint() throws Exception {
        try (Resource lock = this.mutex.checkPoint();){
            this.t2.execute(state -> this.mutex.checkPoint());
            this.t2.get().waitUntilWaiting(details -> details.isAt(StoreCopyCheckPointMutex.class, "checkPoint"));
        }
    }

    @Test
    void storeCopyShouldBlockCheckPoint() throws Exception {
        try (Resource lock = this.mutex.storeCopy(ThrowingAction.noop());){
            this.t2.execute(state -> this.mutex.checkPoint());
            this.t2.get().waitUntilWaiting(details -> details.isAt(StoreCopyCheckPointMutex.class, "checkPoint"));
        }
    }

    @Test
    void storeCopyShouldHaveTryCheckPointBackOff() throws Exception {
        try (Resource lock = this.mutex.storeCopy(ThrowingAction.noop());){
            Assertions.assertNull((Object)this.mutex.tryCheckPoint());
        }
    }

    @Test
    void storeCopyShouldAllowAnotherStoreCopy() throws Exception {
        try (Resource lock = this.mutex.storeCopy(ThrowingAction.noop());){
            Resource otherLock = this.mutex.storeCopy(ThrowingAction.noop());
            if (otherLock != null) {
                otherLock.close();
            }
        }
    }

    @Test
    void storeCopyShouldAllowAnotherStoreCopyButOnlyFirstShouldPerformBeforeAction() throws Exception {
        ThrowingAction action = (ThrowingAction)Mockito.mock(ThrowingAction.class);
        try (Resource lock = this.mutex.storeCopy(action);){
            ((ThrowingAction)Mockito.verify((Object)action)).apply();
            try (Resource otherLock = this.mutex.storeCopy(action);){
                ((ThrowingAction)Mockito.verify((Object)action)).apply();
            }
        }
    }

    @Test
    void shouldHandleMultipleConcurrentStoreCopyWhenBeforeActionPerformsCheckPoint() throws Throwable {
        CheckPointingAction checkPointingAction = new CheckPointingAction(this.mutex);
        for (int i = 0; i < 2; ++i) {
            Resource firstLock = this.mutex.storeCopy((ThrowingAction)checkPointingAction);
            Assertions.assertNotNull((Object)checkPointingAction.lock);
            Resource secondLock = this.mutex.storeCopy((ThrowingAction)checkPointingAction);
            firstLock.close();
            Resource thirdLock = this.mutex.storeCopy((ThrowingAction)checkPointingAction);
            thirdLock.close();
            secondLock.close();
            checkPointingAction.unlock();
        }
    }

    @Test
    void shouldHandleMultipleConcurrentStoreCopyRequests() throws Throwable {
        Race race = new Race();
        CountingAction action = new CountingAction();
        int threads = Runtime.getRuntime().availableProcessors() * 10;
        race.addContestants(threads, Race.throwing(() -> {
            StoreCopyCheckPointMutexTest.parkARandomWhile();
            try (Resource lock = this.mutex.storeCopy((ThrowingAction)action);){
                StoreCopyCheckPointMutexTest.parkARandomWhile();
            }
        }));
        race.go();
        MatcherAssert.assertThat((Object)action.count(), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(threads)));
    }

    @Test
    void shouldPropagateStoreCopyActionFailureToOtherStoreCopyRequests() throws Exception {
        Barrier.Control barrier = new Barrier.Control();
        IOException controlledFailure = new IOException("My own fault");
        AtomicReference secondRequest = new AtomicReference();
        ThrowingAction controllableAndFailingAction = () -> {
            secondRequest.set(this.t3.execute(state -> this.mutex.storeCopy(ASSERT_NOT_CALLED)));
            barrier.awaitUninterruptibly();
            try {
                throw controlledFailure;
            }
            catch (Throwable throwable) {
                barrier.release();
                throw throwable;
            }
        };
        Future firstRequest = this.t2.execute(state -> this.mutex.storeCopy(controllableAndFailingAction));
        while (secondRequest.get() == null) {
            StoreCopyCheckPointMutexTest.parkARandomWhile();
        }
        this.t3.get().waitUntilWaiting(details -> details.isAt(StoreCopyCheckPointMutex.class, "waitForFirstStoreCopyActionToComplete"));
        barrier.reached();
        try {
            firstRequest.get();
        }
        catch (ExecutionException e) {
            Assertions.assertSame((Object)controlledFailure, (Object)e.getCause());
        }
        try {
            ((Future)secondRequest.get()).get();
        }
        catch (ExecutionException e) {
            Throwable cooperativeActionFailure = e.getCause();
            MatcherAssert.assertThat((Object)cooperativeActionFailure.getMessage(), (Matcher)Matchers.containsString((String)"Co-operative"));
            Assertions.assertSame((Object)controlledFailure, (Object)cooperativeActionFailure.getCause());
        }
        CountingAction action = new CountingAction();
        try (Resource lock = this.mutex.storeCopy((ThrowingAction)action);){
            Assertions.assertEquals((int)1, (int)action.count());
        }
    }

    private static void parkARandomWhile() {
        LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(ThreadLocalRandom.current().nextInt(10)));
    }

    private static class CountingAction
    implements ThrowingAction<IOException> {
        private final AtomicInteger count = new AtomicInteger();

        private CountingAction() {
        }

        public void apply() {
            StoreCopyCheckPointMutexTest.parkARandomWhile();
            this.count.incrementAndGet();
        }

        int count() {
            return this.count.get();
        }
    }

    private static class CheckPointingAction
    implements ThrowingAction<IOException> {
        private final StoreCopyCheckPointMutex mutex;
        private Resource lock;

        CheckPointingAction(StoreCopyCheckPointMutex mutex) {
            this.mutex = mutex;
        }

        public void apply() {
            Assertions.assertNull((Object)this.lock);
            this.lock = this.mutex.checkPoint();
        }

        void unlock() {
            Assertions.assertNotNull((Object)this.lock);
            this.lock.close();
            this.lock = null;
        }
    }
}

