/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.stresstest.workload;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ThreadLocalRandom;
import org.neo4j.kernel.impl.api.TestCommand;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.storageengine.api.StorageCommand;

class TransactionRepresentationFactory {
    private final CommandGenerator commandGenerator = new CommandGenerator();

    TransactionRepresentationFactory() {
    }

    TransactionToApply nextTransaction(long txId) {
        PhysicalTransactionRepresentation representation = new PhysicalTransactionRepresentation(this.createRandomCommands());
        representation.setHeader(new byte[0], System.currentTimeMillis(), txId, System.currentTimeMillis(), 42);
        return new TransactionToApply((TransactionRepresentation)representation);
    }

    private Collection<StorageCommand> createRandomCommands() {
        int commandNum = ThreadLocalRandom.current().nextInt(1, 17);
        ArrayList<StorageCommand> commands = new ArrayList<StorageCommand>(commandNum);
        for (int i = 0; i < commandNum; ++i) {
            commands.add(this.commandGenerator.nextCommand());
        }
        return commands;
    }

    private static class CommandGenerator {
        private final ThreadLocalRandom random = ThreadLocalRandom.current();

        private CommandGenerator() {
        }

        StorageCommand nextCommand() {
            int length = this.random.nextInt(101);
            byte[] bytes = new byte[length];
            this.random.nextBytes(bytes);
            return new TestCommand(bytes);
        }
    }
}

