/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.rule;

import java.time.Clock;
import java.util.function.Function;
import java.util.function.LongFunction;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.database.DatabaseConfig;
import org.neo4j.exceptions.UnsatisfiedDependencyException;
import org.neo4j.function.Factory;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.id.BufferedIdController;
import org.neo4j.internal.id.BufferingIdGeneratorFactory;
import org.neo4j.internal.id.DefaultIdGeneratorFactory;
import org.neo4j.internal.id.IdController;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.watcher.DatabaseLayoutWatcher;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.availability.CompositeDatabaseAvailabilityGuard;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.database.DatabaseCreationContext;
import org.neo4j.kernel.database.DatabaseNameLogContext;
import org.neo4j.kernel.database.DatabaseStartupController;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.TestDatabaseIdRepository;
import org.neo4j.kernel.diagnostics.providers.DbmsDiagnosticsManager;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.ExtensionType;
import org.neo4j.kernel.extension.context.ExtensionContext;
import org.neo4j.kernel.impl.api.CommitProcessFactory;
import org.neo4j.kernel.impl.api.LeaseService;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.constraints.StandardConstraintSemantics;
import org.neo4j.kernel.impl.context.TransactionVersionContextSupplier;
import org.neo4j.kernel.impl.factory.AccessCapability;
import org.neo4j.kernel.impl.factory.AccessCapabilityFactory;
import org.neo4j.kernel.impl.factory.CanWrite;
import org.neo4j.kernel.impl.factory.CommunityCommitProcessFactory;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.StatementLocks;
import org.neo4j.kernel.impl.locking.StatementLocksFactory;
import org.neo4j.kernel.impl.query.QueryEngineProvider;
import org.neo4j.kernel.impl.transaction.log.checkpoint.StoreCopyCheckPointMutex;
import org.neo4j.kernel.impl.transaction.stats.DatabaseTransactionStats;
import org.neo4j.kernel.impl.util.collection.CollectionsFactorySupplier;
import org.neo4j.kernel.internal.event.GlobalTransactionEventListeners;
import org.neo4j.kernel.internal.locker.FileLockerService;
import org.neo4j.kernel.internal.locker.GlobalLockerService;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.kernel.recovery.RecoveryExtension;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.internal.DatabaseLogContext;
import org.neo4j.logging.internal.DatabaseLogService;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.SimpleLogService;
import org.neo4j.monitoring.DatabaseEventListeners;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.DatabasePanicEventGenerator;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.test.rule.ExternalResource;
import org.neo4j.time.Clocks;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.TokenHolder;

public class DatabaseRule
extends ExternalResource {
    private Database database;
    private final TestDatabaseIdRepository databaseIdRepository = new TestDatabaseIdRepository();

    public Database getDatabase(DatabaseLayout databaseLayout, FileSystemAbstraction fs, PageCache pageCache) {
        return this.getDatabase(databaseLayout, fs, pageCache, (DependencyResolver)new Dependencies());
    }

    public Database getDatabase(String databaseName, DatabaseLayout databaseLayout, FileSystemAbstraction fs, PageCache pageCache) {
        return this.getDatabase(databaseName, databaseLayout, fs, pageCache, (DependencyResolver)new Dependencies());
    }

    public Database getDatabase(DatabaseLayout databaseLayout, FileSystemAbstraction fs, PageCache pageCache, DependencyResolver otherCustomOverriddenDependencies) {
        return this.getDatabase("neo4j", databaseLayout, fs, pageCache, otherCustomOverriddenDependencies);
    }

    public Database getDatabase(String databaseName, DatabaseLayout databaseLayout, FileSystemAbstraction fs, PageCache pageCache, DependencyResolver otherCustomOverriddenDependencies) {
        this.shutdownAnyRunning();
        StatementLocksFactory locksFactory = (StatementLocksFactory)Mockito.mock(StatementLocksFactory.class);
        StatementLocks statementLocks = (StatementLocks)Mockito.mock(StatementLocks.class);
        Locks.Client locks = (Locks.Client)Mockito.mock(Locks.Client.class);
        Mockito.when((Object)statementLocks.optimistic()).thenReturn((Object)locks);
        Mockito.when((Object)statementLocks.pessimistic()).thenReturn((Object)locks);
        Mockito.when((Object)locksFactory.newInstance()).thenReturn((Object)statementLocks);
        JobScheduler jobScheduler = (JobScheduler)Mockito.mock(JobScheduler.class, (Answer)Mockito.RETURNS_MOCKS);
        Monitors monitors = new Monitors();
        Dependencies mutableDependencies = new Dependencies(otherCustomOverriddenDependencies);
        mutableDependencies.satisfyDependency((Object)((CompositeDatabaseAvailabilityGuard)Mockito.mock(CompositeDatabaseAvailabilityGuard.class)));
        Config config = DatabaseRule.dependency(mutableDependencies, Config.class, deps -> Config.defaults());
        config.set(GraphDatabaseSettings.default_schema_provider, (Object)IndexProvider.EMPTY.getProviderDescriptor().name());
        LogService logService = DatabaseRule.dependency(mutableDependencies, LogService.class, deps -> new SimpleLogService((LogProvider)NullLogProvider.getInstance()));
        IdGeneratorFactory idGeneratorFactory = DatabaseRule.dependency(mutableDependencies, IdGeneratorFactory.class, deps -> new DefaultIdGeneratorFactory(fs, RecoveryCleanupWorkCollector.immediate()));
        DatabaseHealth databaseHealth = DatabaseRule.dependency(mutableDependencies, DatabaseHealth.class, deps -> new DatabaseHealth((DatabasePanicEventGenerator)Mockito.mock(DatabasePanicEventGenerator.class), (Log)NullLog.getInstance()));
        SystemNanoClock clock = DatabaseRule.dependency(mutableDependencies, SystemNanoClock.class, deps -> Clocks.nanoClock());
        DatabaseTransactionStats transactionStats = DatabaseRule.dependency(mutableDependencies, DatabaseTransactionStats.class, deps -> new DatabaseTransactionStats());
        DatabaseRule.dependency(mutableDependencies, DbmsDiagnosticsManager.class, deps -> (DbmsDiagnosticsManager)Mockito.mock(DbmsDiagnosticsManager.class));
        StorageEngineFactory storageEngineFactory = DatabaseRule.dependency(mutableDependencies, StorageEngineFactory.class, deps -> StorageEngineFactory.selectStorageEngine());
        NamedDatabaseId namedDatabaseId = this.databaseIdRepository.getRaw(databaseName);
        this.database = new Database((DatabaseCreationContext)new TestDatabaseCreationContext(namedDatabaseId, databaseLayout, config, idGeneratorFactory, logService, (JobScheduler)Mockito.mock(JobScheduler.class, (Answer)Mockito.RETURNS_MOCKS), (TokenNameLookup)Mockito.mock(TokenNameLookup.class), (DependencyResolver)mutableDependencies, DatabaseRule.mockedTokenHolders(), locksFactory, (GlobalTransactionEventListeners)Mockito.mock(GlobalTransactionEventListeners.class), fs, transactionStats, databaseHealth, (CommitProcessFactory)new CommunityCommitProcessFactory(), pageCache, (ConstraintSemantics)new StandardConstraintSemantics(), monitors, new Tracers("null", (Log)NullLog.getInstance(), monitors, jobScheduler, clock), (GlobalProcedures)Mockito.mock(GlobalProcedures.class), IOLimiter.UNLIMITED, clock, new StoreCopyCheckPointMutex(), (IdController)new BufferedIdController(new BufferingIdGeneratorFactory(idGeneratorFactory), jobScheduler), DatabaseInfo.COMMUNITY, (VersionContextSupplier)new TransactionVersionContextSupplier(), CollectionsFactorySupplier.ON_HEAP, Iterables.iterable((Object[])new EmptyIndexExtensionFactory[]{new EmptyIndexExtensionFactory()}), file -> (DatabaseLayoutWatcher)Mockito.mock(DatabaseLayoutWatcher.class), null, storageEngineFactory, (FileLockerService)new GlobalLockerService(), LeaseService.NO_LEASES, DatabaseStartupController.NEVER_ABORT));
        return this.database;
    }

    private static <T> T dependency(Dependencies dependencies, Class<T> type, Function<DependencyResolver, T> defaultSupplier) {
        try {
            return (T)dependencies.resolveDependency(type);
        }
        catch (IllegalArgumentException | UnsatisfiedDependencyException e) {
            return (T)dependencies.satisfyDependency(defaultSupplier.apply((DependencyResolver)dependencies));
        }
    }

    private void shutdownAnyRunning() {
        if (this.database != null) {
            this.database.stop();
        }
    }

    protected void after(boolean successful) {
        this.shutdownAnyRunning();
    }

    public static TokenHolders mockedTokenHolders() {
        return new TokenHolders((TokenHolder)Mockito.mock(TokenHolder.class), (TokenHolder)Mockito.mock(TokenHolder.class), (TokenHolder)Mockito.mock(TokenHolder.class));
    }

    @RecoveryExtension
    private static class EmptyIndexExtensionFactory
    extends ExtensionFactory<Dependencies> {
        EmptyIndexExtensionFactory() {
            super(ExtensionType.DATABASE, "customExtension");
        }

        public Lifecycle newInstance(ExtensionContext context, Dependencies dependencies) {
            return IndexProvider.EMPTY;
        }

        static interface Dependencies {
        }
    }

    private static class TestDatabaseCreationContext
    implements DatabaseCreationContext {
        private final NamedDatabaseId namedDatabaseId;
        private final DatabaseLayout databaseLayout;
        private final Config config;
        private final LeaseService leaseService;
        private final DatabaseStartupController startupController;
        private final DatabaseConfig databaseConfig;
        private final IdGeneratorFactory idGeneratorFactory;
        private final DatabaseLogService logService;
        private final JobScheduler scheduler;
        private final TokenNameLookup tokenNameLookup;
        private final DependencyResolver dependencyResolver;
        private final TokenHolders tokenHolders;
        private final StatementLocksFactory statementLocksFactory;
        private final GlobalTransactionEventListeners globalTransactionEventListeners;
        private final FileSystemAbstraction fs;
        private final DatabaseTransactionStats databaseTransactionStats;
        private final DatabaseHealth databaseHealth;
        private final CommitProcessFactory commitProcessFactory;
        private final PageCache pageCache;
        private final ConstraintSemantics constraintSemantics;
        private final Monitors monitors;
        private final Tracers tracers;
        private final GlobalProcedures globalProcedures;
        private final IOLimiter ioLimiter;
        private final SystemNanoClock clock;
        private final StoreCopyCheckPointMutex storeCopyCheckPointMutex;
        private final IdController idController;
        private final DatabaseInfo databaseInfo;
        private final VersionContextSupplier versionContextSupplier;
        private final CollectionsFactorySupplier collectionsFactorySupplier;
        private final Iterable<ExtensionFactory<?>> extensionFactories;
        private final Function<DatabaseLayout, DatabaseLayoutWatcher> watcherServiceFactory;
        private final QueryEngineProvider engineProvider;
        private final DatabaseEventListeners eventListeners;
        private final StorageEngineFactory storageEngineFactory;
        private final FileLockerService fileLockerService;

        TestDatabaseCreationContext(NamedDatabaseId namedDatabaseId, DatabaseLayout databaseLayout, Config config, IdGeneratorFactory idGeneratorFactory, LogService logService, JobScheduler scheduler, TokenNameLookup tokenNameLookup, DependencyResolver dependencyResolver, TokenHolders tokenHolders, StatementLocksFactory statementLocksFactory, GlobalTransactionEventListeners globalTransactionEventListeners, FileSystemAbstraction fs, DatabaseTransactionStats databaseTransactionStats, DatabaseHealth databaseHealth, CommitProcessFactory commitProcessFactory, PageCache pageCache, ConstraintSemantics constraintSemantics, Monitors monitors, Tracers tracers, GlobalProcedures globalProcedures, IOLimiter ioLimiter, SystemNanoClock clock, StoreCopyCheckPointMutex storeCopyCheckPointMutex, IdController idController, DatabaseInfo databaseInfo, VersionContextSupplier versionContextSupplier, CollectionsFactorySupplier collectionsFactorySupplier, Iterable<ExtensionFactory<?>> extensionFactories, Function<DatabaseLayout, DatabaseLayoutWatcher> watcherServiceFactory, QueryEngineProvider engineProvider, StorageEngineFactory storageEngineFactory, FileLockerService fileLockerService, LeaseService leaseService, DatabaseStartupController startupController) {
            this.namedDatabaseId = namedDatabaseId;
            this.databaseLayout = databaseLayout;
            this.config = config;
            this.leaseService = leaseService;
            this.startupController = startupController;
            this.databaseConfig = new DatabaseConfig(config, namedDatabaseId);
            this.idGeneratorFactory = idGeneratorFactory;
            this.logService = new DatabaseLogService((DatabaseLogContext)new DatabaseNameLogContext(namedDatabaseId), logService);
            this.scheduler = scheduler;
            this.tokenNameLookup = tokenNameLookup;
            this.dependencyResolver = dependencyResolver;
            this.tokenHolders = tokenHolders;
            this.statementLocksFactory = statementLocksFactory;
            this.globalTransactionEventListeners = globalTransactionEventListeners;
            this.fs = fs;
            this.databaseTransactionStats = databaseTransactionStats;
            this.databaseHealth = databaseHealth;
            this.commitProcessFactory = commitProcessFactory;
            this.pageCache = pageCache;
            this.constraintSemantics = constraintSemantics;
            this.monitors = monitors;
            this.tracers = tracers;
            this.globalProcedures = globalProcedures;
            this.ioLimiter = ioLimiter;
            this.clock = clock;
            this.storeCopyCheckPointMutex = storeCopyCheckPointMutex;
            this.idController = idController;
            this.databaseInfo = databaseInfo;
            this.versionContextSupplier = versionContextSupplier;
            this.collectionsFactorySupplier = collectionsFactorySupplier;
            this.extensionFactories = extensionFactories;
            this.watcherServiceFactory = watcherServiceFactory;
            this.engineProvider = engineProvider;
            this.eventListeners = (DatabaseEventListeners)Mockito.mock(DatabaseEventListeners.class);
            this.storageEngineFactory = storageEngineFactory;
            this.fileLockerService = fileLockerService;
        }

        public NamedDatabaseId getNamedDatabaseId() {
            return this.namedDatabaseId;
        }

        public DatabaseLayout getDatabaseLayout() {
            return this.databaseLayout;
        }

        public Config getGlobalConfig() {
            return this.config;
        }

        public DatabaseConfig getDatabaseConfig() {
            return this.databaseConfig;
        }

        public IdGeneratorFactory getIdGeneratorFactory() {
            return this.idGeneratorFactory;
        }

        public DatabaseLogService getDatabaseLogService() {
            return this.logService;
        }

        public JobScheduler getScheduler() {
            return this.scheduler;
        }

        public TokenNameLookup getTokenNameLookup() {
            return this.tokenNameLookup;
        }

        public DependencyResolver getGlobalDependencies() {
            return this.dependencyResolver;
        }

        public DependencyResolver getDependencyResolver() {
            return this.dependencyResolver;
        }

        public TokenHolders getTokenHolders() {
            return this.tokenHolders;
        }

        public Locks getLocks() {
            return (Locks)Mockito.mock(Locks.class);
        }

        public StatementLocksFactory getStatementLocksFactory() {
            return this.statementLocksFactory;
        }

        public GlobalTransactionEventListeners getTransactionEventListeners() {
            return this.globalTransactionEventListeners;
        }

        public FileSystemAbstraction getFs() {
            return this.fs;
        }

        public DatabaseTransactionStats getTransactionStats() {
            return this.databaseTransactionStats;
        }

        public Factory<DatabaseHealth> getDatabaseHealthFactory() {
            return () -> this.databaseHealth;
        }

        public CommitProcessFactory getCommitProcessFactory() {
            return this.commitProcessFactory;
        }

        public PageCache getPageCache() {
            return this.pageCache;
        }

        public ConstraintSemantics getConstraintSemantics() {
            return this.constraintSemantics;
        }

        public Monitors getMonitors() {
            return this.monitors;
        }

        public Tracers getTracers() {
            return this.tracers;
        }

        public GlobalProcedures getGlobalProcedures() {
            return this.globalProcedures;
        }

        public IOLimiter getIoLimiter() {
            return this.ioLimiter;
        }

        public LongFunction<DatabaseAvailabilityGuard> getDatabaseAvailabilityGuardFactory() {
            return timeout -> new DatabaseAvailabilityGuard(this.namedDatabaseId, (Clock)this.clock, (Log)NullLog.getInstance(), timeout, (CompositeDatabaseAvailabilityGuard)Mockito.mock(CompositeDatabaseAvailabilityGuard.class));
        }

        public SystemNanoClock getClock() {
            return this.clock;
        }

        public StoreCopyCheckPointMutex getStoreCopyCheckPointMutex() {
            return this.storeCopyCheckPointMutex;
        }

        public IdController getIdController() {
            return this.idController;
        }

        public DatabaseInfo getDatabaseInfo() {
            return this.databaseInfo;
        }

        public VersionContextSupplier getVersionContextSupplier() {
            return this.versionContextSupplier;
        }

        public CollectionsFactorySupplier getCollectionsFactorySupplier() {
            return this.collectionsFactorySupplier;
        }

        public Iterable<ExtensionFactory<?>> getExtensionFactories() {
            return this.extensionFactories;
        }

        public Function<DatabaseLayout, DatabaseLayoutWatcher> getWatcherServiceFactory() {
            return this.watcherServiceFactory;
        }

        public QueryEngineProvider getEngineProvider() {
            return this.engineProvider;
        }

        public DatabaseEventListeners getDatabaseEventListeners() {
            return this.eventListeners;
        }

        public StorageEngineFactory getStorageEngineFactory() {
            return this.storageEngineFactory;
        }

        public FileLockerService getFileLockerService() {
            return this.fileLockerService;
        }

        public AccessCapabilityFactory getAccessCapabilityFactory() {
            return AccessCapabilityFactory.fixed((AccessCapability)new CanWrite());
        }

        public LeaseService getLeaseService() {
            return this.leaseService;
        }

        public DatabaseStartupController getStartupController() {
            return this.startupController;
        }
    }
}

