/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.onlab.util.Frequency;
import org.onlab.util.Spectrum;
import org.onosproject.net.ChannelSpacing;
import org.onosproject.net.DefaultOchSignalComparator;
import org.onosproject.net.GridType;
import org.onosproject.net.Lambda;

public class OchSignal
implements Lambda {
    public static final Set<Integer> FIXED_GRID_SLOT_GRANULARITIES = ImmutableSet.of((Object)1, (Object)2, (Object)4, (Object)8);
    private static final GridType DEFAULT_OCH_GRIDTYPE = GridType.DWDM;
    private static final ChannelSpacing DEFAULT_CHANNEL_SPACING = ChannelSpacing.CHL_50GHZ;
    private final GridType gridType;
    private final ChannelSpacing channelSpacing;
    private final int spacingMultiplier;
    private final int slotGranularity;

    public OchSignal(GridType gridType, ChannelSpacing channelSpacing, int spacingMultiplier, int slotGranularity) {
        this.gridType = (GridType)((Object)Preconditions.checkNotNull((Object)((Object)gridType)));
        this.channelSpacing = (ChannelSpacing)((Object)Preconditions.checkNotNull((Object)((Object)channelSpacing)));
        this.spacingMultiplier = spacingMultiplier;
        Preconditions.checkArgument((slotGranularity > 0 ? 1 : 0) != 0, (String)"slotGranularity must be larger than 0, received %s", (int)slotGranularity);
        this.slotGranularity = slotGranularity;
    }

    public static OchSignal newFlexGridSlot(int index) {
        return new OchSignal(GridType.FLEX, ChannelSpacing.CHL_6P25GHZ, index, 1);
    }

    public static OchSignal newDwdmSlot(ChannelSpacing spacing, int index) {
        return new OchSignal(GridType.DWDM, spacing, index, (int)(spacing.frequency().asHz() / ChannelSpacing.CHL_12P5GHZ.frequency().asHz()));
    }

    @Deprecated
    public OchSignal(Frequency centerFrequency, ChannelSpacing channelSpacing, int slotGranularity) {
        this.gridType = DEFAULT_OCH_GRIDTYPE;
        this.channelSpacing = channelSpacing;
        this.spacingMultiplier = (int)Math.round((double)centerFrequency.subtract(Spectrum.CENTER_FREQUENCY).asHz() / (double)this.channelSpacing().frequency().asHz());
        this.slotGranularity = slotGranularity;
    }

    public GridType gridType() {
        return this.gridType;
    }

    public ChannelSpacing channelSpacing() {
        return this.channelSpacing;
    }

    public int spacingMultiplier() {
        return this.spacingMultiplier;
    }

    public int slotGranularity() {
        return this.slotGranularity;
    }

    public Frequency centralFrequency() {
        return Spectrum.CENTER_FREQUENCY.add(this.channelSpacing().frequency().multiply((long)this.spacingMultiplier));
    }

    public Frequency slotWidth() {
        return ChannelSpacing.CHL_12P5GHZ.frequency().multiply((long)this.slotGranularity);
    }

    public static SortedSet<OchSignal> toFlexGrid(OchSignal ochSignal) {
        Preconditions.checkArgument((ochSignal.gridType() != GridType.FLEX ? 1 : 0) != 0, (Object)((Object)ochSignal.gridType()));
        Preconditions.checkArgument((ochSignal.channelSpacing() != ChannelSpacing.CHL_6P25GHZ ? 1 : 0) != 0, (Object)((Object)ochSignal.channelSpacing()));
        Preconditions.checkArgument((boolean)FIXED_GRID_SLOT_GRANULARITIES.contains(ochSignal.slotGranularity()), (Object)ochSignal.slotGranularity());
        int startMultiplier = (int)((long)(1 - ochSignal.slotGranularity()) + (long)ochSignal.spacingMultiplier() * ochSignal.channelSpacing().frequency().asHz() / ChannelSpacing.CHL_6P25GHZ.frequency().asHz());
        return IntStream.range(0, ochSignal.slotGranularity()).mapToObj(i -> new OchSignal(GridType.FLEX, ChannelSpacing.CHL_6P25GHZ, startMultiplier + 2 * i, 1)).collect(Collectors.toCollection(DefaultOchSignalComparator::newOchSignalTreeSet));
    }

    public static OchSignal toFixedGrid(List<OchSignal> lambdas, ChannelSpacing spacing) {
        int ratio = (int)(spacing.frequency().asHz() / ChannelSpacing.CHL_12P5GHZ.frequency().asHz());
        Preconditions.checkArgument((lambdas.size() == ratio ? 1 : 0) != 0, (String)"%s != %s", (int)lambdas.size(), (int)ratio);
        lambdas.forEach(x -> Preconditions.checkArgument((x.gridType() == GridType.FLEX ? 1 : 0) != 0, (Object)((Object)x.gridType())));
        lambdas.forEach(x -> Preconditions.checkArgument((x.channelSpacing() == ChannelSpacing.CHL_6P25GHZ ? 1 : 0) != 0, (Object)((Object)x.channelSpacing())));
        lambdas.forEach(x -> Preconditions.checkArgument((x.slotGranularity() == 1 ? 1 : 0) != 0, (Object)x.slotGranularity()));
        IntStream.range(1, lambdas.size()).forEach(i -> Preconditions.checkArgument((((OchSignal)lambdas.get(i)).spacingMultiplier() == ((OchSignal)lambdas.get(i - 1)).spacingMultiplier() + 2 ? 1 : 0) != 0));
        int spacingMultiplier = lambdas.stream().mapToInt(OchSignal::spacingMultiplier).sum() / lambdas.size() / (int)(spacing.frequency().asHz() / ChannelSpacing.CHL_6P25GHZ.frequency().asHz());
        return new OchSignal(GridType.DWDM, spacing, spacingMultiplier, lambdas.size());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.gridType, this.channelSpacing, this.spacingMultiplier, this.slotGranularity});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OchSignal)) {
            return false;
        }
        OchSignal other = (OchSignal)obj;
        return Objects.equals((Object)this.gridType, (Object)other.gridType) && Objects.equals((Object)this.channelSpacing, (Object)other.channelSpacing) && Objects.equals(this.spacingMultiplier, other.spacingMultiplier) && Objects.equals(this.slotGranularity, other.slotGranularity);
    }

    public String toString() {
        return String.format("%s{%+d\u00d7%.2fGHz \u00b1 %.2fGHz}", this.getClass().getSimpleName(), this.spacingMultiplier, (double)this.channelSpacing.frequency().asHz() / (double)Frequency.ofGHz((long)1L).asHz(), (double)this.slotGranularity * (double)this.channelSpacing.frequency().asHz() / (double)Frequency.ofGHz((long)1L).asHz() / 2.0);
    }
}

