/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.criteria;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.net.flow.criteria.Criterion;

public final class VlanPcpCriterion
implements Criterion {
    private static final byte MASK = 7;
    private final byte vlanPcp;
    private final Criterion.Type type;

    VlanPcpCriterion(byte vlanPcp) {
        this.vlanPcp = (byte)(vlanPcp & 7);
        this.type = Criterion.Type.VLAN_PCP;
    }

    VlanPcpCriterion(byte vlanPcp, Criterion.Type type) {
        Preconditions.checkArgument((type == Criterion.Type.INNER_VLAN_PCP || type == Criterion.Type.VLAN_PCP ? 1 : 0) != 0, (Object)"Type can only be inner vlan or vlan");
        this.vlanPcp = (byte)(vlanPcp & 7);
        this.type = type;
    }

    @Override
    public Criterion.Type type() {
        return this.type;
    }

    public byte priority() {
        return this.vlanPcp;
    }

    public String toString() {
        return this.type().toString() + ":" + Long.toHexString(this.vlanPcp);
    }

    public int hashCode() {
        return Objects.hash(this.type().ordinal(), this.vlanPcp);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof VlanPcpCriterion) {
            VlanPcpCriterion that = (VlanPcpCriterion)obj;
            return Objects.equals(this.vlanPcp, that.vlanPcp) && Objects.equals((Object)this.type(), (Object)that.type());
        }
        return false;
    }
}

