/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.onosproject.net.pi.model.PiActionProfileId;
import org.onosproject.net.pi.runtime.PiActionProfileGroupId;
import org.onosproject.net.pi.runtime.PiActionProfileMember;
import org.onosproject.net.pi.runtime.PiActionProfileMemberId;
import org.onosproject.net.pi.runtime.PiEntity;
import org.onosproject.net.pi.runtime.PiEntityType;

@Beta
public final class PiActionProfileGroup
implements PiEntity {
    private final PiActionProfileGroupId id;
    private final ImmutableSet<PiActionProfileMember> members;
    private final PiActionProfileId actionProfileId;

    private PiActionProfileGroup(PiActionProfileGroupId id, ImmutableSet<PiActionProfileMember> members, PiActionProfileId actionProfileId) {
        this.id = id;
        this.members = members;
        this.actionProfileId = actionProfileId;
    }

    public PiActionProfileGroupId id() {
        return this.id;
    }

    public Collection<PiActionProfileMember> members() {
        return this.members;
    }

    public PiActionProfileId actionProfileId() {
        return this.actionProfileId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof PiActionProfileGroup)) {
            return false;
        }
        PiActionProfileGroup that = (PiActionProfileGroup)o;
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal(this.members, that.members) && Objects.equal((Object)((Object)this.actionProfileId), (Object)((Object)that.actionProfileId));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.members});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("groupId", (Object)this.id).add("members", this.members).add("piActionProfileId", (Object)this.actionProfileId).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public PiEntityType piEntityType() {
        return PiEntityType.ACTION_PROFILE_GROUP;
    }

    public static final class Builder {
        private PiActionProfileGroupId id;
        private Map<PiActionProfileMemberId, PiActionProfileMember> members = Maps.newHashMap();
        private PiActionProfileId piActionProfileId;

        private Builder() {
        }

        public Builder withId(PiActionProfileGroupId id) {
            this.id = id;
            return this;
        }

        public Builder addMember(PiActionProfileMember member) {
            this.members.put(member.id(), member);
            return this;
        }

        public Builder addMembers(Collection<PiActionProfileMember> members) {
            members.forEach(this::addMember);
            return this;
        }

        public Builder withActionProfileId(PiActionProfileId piActionProfileId) {
            this.piActionProfileId = piActionProfileId;
            return this;
        }

        public PiActionProfileGroup build() {
            Preconditions.checkNotNull((Object)this.id);
            Preconditions.checkNotNull((Object)((Object)this.piActionProfileId));
            return new PiActionProfileGroup(this.id, ImmutableSet.copyOf(this.members.values()), this.piActionProfileId);
        }
    }
}

