/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import org.onosproject.net.pi.runtime.PiCounterCellData;
import org.onosproject.net.pi.runtime.PiCounterCellId;

@Beta
public final class PiCounterCell {
    private final PiCounterCellId cellId;
    private final PiCounterCellData counterData;

    public PiCounterCell(PiCounterCellId cellId, PiCounterCellData piCounterCellData) {
        this.cellId = cellId;
        this.counterData = piCounterCellData;
    }

    public PiCounterCell(PiCounterCellId cellId, long packets, long bytes) {
        this.cellId = cellId;
        this.counterData = new PiCounterCellData(packets, bytes);
    }

    public PiCounterCellId cellId() {
        return this.cellId;
    }

    public PiCounterCellData data() {
        return this.counterData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PiCounterCell)) {
            return false;
        }
        PiCounterCell that = (PiCounterCell)o;
        return Objects.equal((Object)this.cellId, (Object)that.cellId) && Objects.equal((Object)this.counterData, (Object)that.counterData);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.cellId, this.counterData});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("cellId", (Object)this.cellId).add("counterData", (Object)this.counterData).toString();
    }
}

