/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.security;

import com.google.common.annotations.Beta;
import org.onlab.osgi.DefaultServiceDirectory;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.osgi.ServiceNotFoundException;
import org.onosproject.core.ApplicationId;
import org.onosproject.security.SecurityAdminService;

@Beta
public final class SecurityUtil {
    protected static ServiceDirectory serviceDirectory = new DefaultServiceDirectory();

    private SecurityUtil() {
    }

    public static boolean isSecurityModeEnabled() {
        if (System.getSecurityManager() != null) {
            try {
                SecurityAdminService securityService = (SecurityAdminService)serviceDirectory.get(SecurityAdminService.class);
                if (securityService != null) {
                    return true;
                }
            }
            catch (ServiceNotFoundException e) {
                return false;
            }
        }
        return false;
    }

    public static SecurityAdminService getSecurityService() {
        if (System.getSecurityManager() != null) {
            try {
                SecurityAdminService securityService = (SecurityAdminService)serviceDirectory.get(SecurityAdminService.class);
                if (securityService != null) {
                    return securityService;
                }
            }
            catch (ServiceNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    public static boolean isAppSecured(ApplicationId appId) {
        SecurityAdminService service = SecurityUtil.getSecurityService();
        if (service != null && !service.isSecured(appId)) {
            System.out.println("\n*******************************");
            System.out.println("      SM-ONOS APP WARNING      ");
            System.out.println("*******************************");
            System.out.println(appId.name() + " has not been secured.");
            System.out.println("Please review before activating.");
            return false;
        }
        return true;
    }

    public static void register(ApplicationId appId) {
        SecurityAdminService service = SecurityUtil.getSecurityService();
        if (service != null) {
            service.register(appId);
        }
    }
}

