/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.Task;
import org.onosproject.store.service.WorkQueueStats;

public interface WorkQueue<E>
extends DistributedPrimitive {
    @Override
    default public DistributedPrimitive.Type primitiveType() {
        return DistributedPrimitive.Type.WORK_QUEUE;
    }

    public CompletableFuture<Void> addMultiple(Collection<E> var1);

    public CompletableFuture<Collection<Task<E>>> take(int var1);

    public CompletableFuture<Void> complete(Collection<String> var1);

    public CompletableFuture<Void> registerTaskProcessor(Consumer<E> var1, int var2, Executor var3);

    public CompletableFuture<Void> stopProcessing();

    public CompletableFuture<WorkQueueStats> stats();

    default public CompletableFuture<Void> complete(String ... taskIds) {
        return this.complete(Arrays.asList(taskIds));
    }

    default public CompletableFuture<Void> addOne(E item) {
        return this.addMultiple((Collection<E>)ImmutableList.of(item));
    }

    default public CompletableFuture<Task<E>> take() {
        return this.take(1).thenApply(tasks -> tasks.isEmpty() ? null : (Task)tasks.iterator().next());
    }
}

