/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstackinterface.web;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.openstackinterface.OpenstackNetwork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenstackNetworkCodec
extends JsonCodec<OpenstackNetwork> {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String NETWORK = "network";
    private static final String NAME = "name";
    private static final String TENANT_ID = "tenant_id";
    private static final String SEGMENTATION_ID = "provider:segmentation_id";
    private static final String NETWORK_TYPE = "provider:network_type";
    private static final String ID = "id";

    public OpenstackNetwork decode(ObjectNode json, CodecContext context) {
        JsonNode networkInfo = json.get(NETWORK);
        if (networkInfo == null) {
            networkInfo = json;
        }
        String name = networkInfo.path(NAME).asText();
        String tenantId = networkInfo.path(TENANT_ID).asText();
        String id = networkInfo.path(ID).asText();
        OpenstackNetwork.Builder onb = OpenstackNetwork.builder();
        onb.name(name).tenantId(tenantId).id(id);
        if (networkInfo.path(NETWORK_TYPE).isMissingNode()) {
            this.log.debug("Network {} has no network type, ignore it.", (Object)name);
            return null;
        }
        String networkType = networkInfo.path(NETWORK_TYPE).asText();
        try {
            onb.networkType(OpenstackNetwork.NetworkType.valueOf((String)networkType.toUpperCase()));
        }
        catch (IllegalArgumentException e) {
            this.log.debug("Network {} has unsupported network type {}, ignore it.", (Object)name, (Object)networkType);
            return null;
        }
        onb.segmentId(networkInfo.path(SEGMENTATION_ID).asText());
        return onb.build();
    }
}

