/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstackinterface.web;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.openstackinterface.OpenstackRouterInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenstackRouterInterfaceCodec
extends JsonCodec<OpenstackRouterInterface> {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String ID = "id";
    private static final String TENANT_ID = "tenant_id";
    private static final String SUBNET_ID = "subnet_id";
    private static final String PORT_ID = "port_id";

    public OpenstackRouterInterface decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        ObjectNode routerIfInfo = json;
        String id = (String)Preconditions.checkNotNull((Object)routerIfInfo.path(ID).asText());
        String tenantId = (String)Preconditions.checkNotNull((Object)routerIfInfo.path(TENANT_ID).asText());
        String subnetId = (String)Preconditions.checkNotNull((Object)routerIfInfo.path(SUBNET_ID).asText());
        String portId = (String)Preconditions.checkNotNull((Object)routerIfInfo.path(PORT_ID).asText());
        OpenstackRouterInterface.Builder osBuilder = new OpenstackRouterInterface.Builder().id(id).tenantId(tenantId).subnetId(subnetId).portId(portId);
        return osBuilder.build();
    }
}

