/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.pattern;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.FatalImplementationErrorException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.iface.Shutdownable;
import org.openbase.jul.pattern.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Observable<T>
extends Shutdownable {
    public void waitForValue(long var1, TimeUnit var3) throws CouldNotPerformException, InterruptedException;

    default public void waitForValue() throws CouldNotPerformException, InterruptedException {
        try {
            this.waitForValue(0L, TimeUnit.MILLISECONDS);
        }
        catch (NotAvailableException ex) {
            ExceptionPrinter.printHistory((Throwable)new FatalImplementationErrorException("Observable has notified without valid value!", (Object)this, (Throwable)ex), (Logger)LoggerFactory.getLogger(this.getClass()));
        }
    }

    public void addObserver(Observer<T> var1);

    public void removeObserver(Observer<T> var1);

    public T getValue() throws NotAvailableException;

    public Future<T> getValueFuture();

    public boolean isValueAvailable();

    @Deprecated
    default public T getLatestValue() throws NotAvailableException {
        return this.getValue();
    }
}

