/*
 * Decompiled with CFR 0.152.
 */
package org.openbaton.plugin;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import org.openbaton.catalogue.nfvo.ManagerCredentials;
import org.openbaton.plugin.PluginListener;
import org.openbaton.plugin.utils.Utils;
import org.openbaton.registration.Registration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginStarter {
    protected static final Logger log = LoggerFactory.getLogger(PluginStarter.class);
    private static Map<String, PluginListener> plugins = new HashMap<String, PluginListener>();
    private static Properties properties;
    private static ExecutorService executor;

    private static String getFinalName(Class clazz, String name) throws IOException {
        PluginStarter.getProperties(clazz);
        String inte = Utils.checkInterface(clazz);
        if (inte.equals("unknown-interface")) {
            throw new RuntimeException("The plugin class " + clazz.getSimpleName() + " needs to extend or VimDriver or Monitoring classes");
        }
        return inte + "." + properties.getProperty("type", "unknown") + "." + name;
    }

    private static void getProperties(Class clazz) throws IOException {
        properties = new Properties();
        properties.load(clazz.getResourceAsStream("/plugin.conf.properties"));
    }

    public static void registerPlugin(Class clazz, String name, String brokerIp, int port, int consumers) throws IOException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, TimeoutException, InterruptedException {
        PluginStarter.registerPlugin(clazz, name, brokerIp, port, consumers, true);
    }

    public static void registerPlugin(Class clazz, String name, String brokerIp, int port, int consumers, boolean durable) throws IOException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, TimeoutException, InterruptedException {
        PluginStarter.getProperties(clazz);
        String username = properties.getProperty("username", "openbaton-manager-user");
        String password = properties.getProperty("password", "openbaton");
        String virtualHost = properties.getProperty("virtual-host", "/");
        PluginStarter.registerPlugin(clazz, name, brokerIp, port, consumers, username, password, virtualHost, durable);
    }

    protected static void registerPlugin(Class clazz, String name, final String brokerIp, final int port, int consumers, final String username, final String password, final String virtualHost, boolean queueDurable) throws IOException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, TimeoutException, InterruptedException {
        String pluginId = PluginStarter.getFinalName(clazz, name);
        final Registration registration = new Registration();
        final ManagerCredentials managerCredentials = registration.registerPluginToNfvo(brokerIp, port, username, password, virtualHost, pluginId);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    registration.deregisterPluginFromNfvo(brokerIp, port, username, password, virtualHost, managerCredentials.getRabbitUsername(), managerCredentials.getRabbitPassword());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (TimeoutException e) {
                    e.printStackTrace();
                }
            }
        });
        if (properties == null) {
            PluginStarter.getProperties(clazz);
        }
        executor = Executors.newFixedThreadPool(consumers);
        for (int i = 0; i < consumers; ++i) {
            PluginListener pluginListener = new PluginListener();
            pluginListener.setDurable(queueDurable);
            pluginListener.setPluginId(pluginId);
            pluginListener.setPluginInstance(clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
            pluginListener.setBrokerIp(brokerIp);
            pluginListener.setBrokerPort(port);
            pluginListener.setUsername(managerCredentials.getRabbitUsername());
            pluginListener.setPassword(managerCredentials.getRabbitPassword());
            pluginListener.setVirtualHost(virtualHost);
            executor.execute(pluginListener);
        }
    }
}

