/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.morpheus.api.io;

import java.io.Serializable;
import java.util.concurrent.Executors;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructType;
import org.opencypher.morpheus.api.MorpheusSession;
import org.opencypher.morpheus.api.io.AbstractPropertyGraphDataSource$;
import org.opencypher.morpheus.api.io.MorpheusNodeTable$;
import org.opencypher.morpheus.api.io.MorpheusRelationshipTable$;
import org.opencypher.morpheus.api.io.StorageFormat;
import org.opencypher.morpheus.api.io.metadata.MorpheusGraphMetaData;
import org.opencypher.morpheus.api.io.util.MorpheusGraphExport$;
import org.opencypher.morpheus.api.io.util.MorpheusGraphExport$CanonicalTableSparkSchema$;
import org.opencypher.morpheus.impl.MorpheusConverters$;
import org.opencypher.morpheus.impl.MorpheusConverters$RichPropertyGraph$;
import org.opencypher.morpheus.impl.io.MorpheusPropertyGraphDataSource;
import org.opencypher.morpheus.impl.table.SparkTable;
import org.opencypher.morpheus.schema.MorpheusSchema;
import org.opencypher.morpheus.schema.MorpheusSchema$;
import org.opencypher.okapi.api.graph.GraphName;
import org.opencypher.okapi.api.graph.GraphName$;
import org.opencypher.okapi.api.graph.PropertyGraph;
import org.opencypher.okapi.api.io.PropertyGraphDataSource;
import org.opencypher.okapi.api.schema.PropertyGraphSchema;
import org.opencypher.okapi.api.types.CypherType;
import org.opencypher.okapi.impl.exception.GraphNotFoundException;
import org.opencypher.okapi.impl.exception.GraphNotFoundException$;
import org.opencypher.okapi.relational.api.graph.RelationalCypherGraph;
import org.opencypher.okapi.relational.api.io.ElementTable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\t%r!B\u0011#\u0011\u0003ic!B\u0018#\u0011\u0003\u0001\u0004\"B\u001c\u0002\t\u0003A\u0004\"B\u001d\u0002\t\u0003Q\u0004\"\u00020\u0002\t\u0003yf!B\u0018#\u0003\u0003\u0019\u0007\"B\u001c\u0006\t\u0003Y\u0007bB\u0014\u0006\u0005\u00045\u0019!\u001c\u0005\u0006e\u00161\ta\u001d\u0005\bo\u0016\u0001\r\u0011\"\u0005y\u0011%\tY!\u0002a\u0001\n#\ti\u0001C\u0004\u0002\u001a\u0015\u0001\u000b\u0015B=\t\u0013\u0005mQ\u00011A\u0005\u0012\u0005u\u0001\"CA\u0011\u000b\u0001\u0007I\u0011CA\u0012\u0011!\t9#\u0002Q!\n\u0005}\u0001bBA\u0015\u000b\u0019E\u00111\u0006\u0005\b\u0003\u007f)a\u0011CA!\u0011!\t9%\u0002D\tE\u0005%\u0003bBA'\u000b\u0019E\u0011q\n\u0005\b\u0003+*a\u0011CA,\u0011\u001d\t9'\u0002D\t\u0003SBq!!\u001d\u0006\r#\t\u0019\bC\u0004\u00020\u00161\t\"!-\t\u000f\u0005mVA\"\u0005\u0002>\"9\u0011qY\u0003\u0007\u0012\u0005%\u0007bBAi\u000b\u0011\u0005\u0013Q\u0004\u0005\b\u0003',A\u0011IAk\u0011\u001d\ty.\u0002C!\u0003CDa!`\u0003\u0005B\u0005\u0015\bBB*\u0006\t\u0003\n\t\u0010C\u0004\u0002|\u0016!\t%!@\t\u000f\t\rQ\u0001\"\u0011\u0003\u0006!9!qA\u0003\u0005\u0012\t%\u0011aH!cgR\u0014\u0018m\u0019;Qe>\u0004XM\u001d;z\u000fJ\f\u0007\u000f\u001b#bi\u0006\u001cv.\u001e:dK*\u00111\u0005J\u0001\u0003S>T!!\n\u0014\u0002\u0007\u0005\u0004\u0018N\u0003\u0002(Q\u0005AQn\u001c:qQ\u0016,8O\u0003\u0002*U\u0005Qq\u000e]3oGf\u0004\b.\u001a:\u000b\u0003-\n1a\u001c:h\u0007\u0001\u0001\"AL\u0001\u000e\u0003\t\u0012q$\u00112tiJ\f7\r\u001e)s_B,'\u000f^=He\u0006\u0004\b\u000eR1uCN{WO]2f'\t\t\u0011\u0007\u0005\u00023k5\t1GC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14G\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00035\naC\\8eK\u000e{Gn],ji\"\u001c\u0015\u0010\u001d5feRK\b/\u001a\u000b\u0004wIK\u0006\u0003\u0002\u001fD\r&s!!P!\u0011\u0005y\u001aT\"A \u000b\u0005\u0001c\u0013A\u0002\u001fs_>$h(\u0003\u0002Cg\u00051\u0001K]3eK\u001aL!\u0001R#\u0003\u00075\u000b\u0007O\u0003\u0002CgA\u0011AhR\u0005\u0003\u0011\u0016\u0013aa\u0015;sS:<\u0007C\u0001&Q\u001b\u0005Y%B\u0001'N\u0003\u0015!\u0018\u0010]3t\u0015\t)cJ\u0003\u0002PQ\u0005)qn[1qS&\u0011\u0011k\u0013\u0002\u000b\u0007f\u0004\b.\u001a:UsB,\u0007\"B*\u0004\u0001\u0004!\u0016AB:dQ\u0016l\u0017\r\u0005\u0002V/6\taK\u0003\u0002T\u001b&\u0011\u0001L\u0016\u0002\u0014!J|\u0007/\u001a:us\u001e\u0013\u0018\r\u001d5TG\",W.\u0019\u0005\u00065\u000e\u0001\raW\u0001\u0011Y\u0006\u0014W\r\\\"p[\nLg.\u0019;j_:\u00042\u0001\u0010/G\u0013\tiVIA\u0002TKR\fQC]3m\u0007>d7oV5uQ\u000eK\b\u000f[3s)f\u0004X\rF\u0002<A\u0006DQa\u0015\u0003A\u0002QCQA\u0019\u0003A\u0002\u0019\u000bqA]3m)f\u0004XmE\u0002\u0006c\u0011\u0004\"!Z5\u000e\u0003\u0019T!aI4\u000b\u0005!4\u0013\u0001B5na2L!A\u001b4\u0003?5{'\u000f\u001d5fkN\u0004&o\u001c9feRLxI]1qQ\u0012\u000bG/Y*pkJ\u001cW\rF\u0001m!\tqS!F\u0001o!\ty\u0007/D\u0001%\u0013\t\tHEA\bN_J\u0004\b.Z;t'\u0016\u001c8/[8o\u0003I!\u0018M\u00197f'R|'/Y4f\r>\u0014X.\u0019;\u0016\u0003Q\u0004\"AL;\n\u0005Y\u0014#!D*u_J\fw-\u001a$pe6\fG/A\u0006tG\",W.Y\"bG\",W#A=\u0011\u000bq\u001a%0!\u0001\u0011\u0005mtX\"\u0001?\u000b\u0005ul\u0015!B4sCBD\u0017BA@}\u0005%9%/\u00199i\u001d\u0006lW\r\u0005\u0003\u0002\u0004\u0005\u001dQBAA\u0003\u0015\t\u0019f%\u0003\u0003\u0002\n\u0005\u0015!AD'peBDW-^:TG\",W.Y\u0001\u0010g\u000eDW-\\1DC\u000eDWm\u0018\u0013fcR!\u0011qBA\u000b!\r\u0011\u0014\u0011C\u0005\u0004\u0003'\u0019$\u0001B+oSRD\u0001\"a\u0006\u000b\u0003\u0003\u0005\r!_\u0001\u0004q\u0012\n\u0014\u0001D:dQ\u0016l\u0017mQ1dQ\u0016\u0004\u0013AD4sCBDg*Y7f\u0007\u0006\u001c\u0007.Z\u000b\u0003\u0003?\u00012\u0001\u0010/{\u0003I9'/\u00199i\u001d\u0006lWmQ1dQ\u0016|F%Z9\u0015\t\u0005=\u0011Q\u0005\u0005\n\u0003/i\u0011\u0011!a\u0001\u0003?\tqb\u001a:ba\"t\u0015-\\3DC\u000eDW\rI\u0001\u000fY&\u001cHo\u0012:ba\"t\u0015-\\3t+\t\ti\u0003E\u0003\u00020\u0005ebI\u0004\u0003\u00022\u0005Ubb\u0001 \u00024%\tA'C\u0002\u00028M\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002<\u0005u\"\u0001\u0002'jgRT1!a\u000e4\u0003-!W\r\\3uK\u001e\u0013\u0018\r\u001d5\u0015\t\u0005=\u00111\t\u0005\u0007\u0003\u000b\u0002\u0002\u0019\u0001>\u0002\u0013\u001d\u0014\u0018\r\u001d5OC6,\u0017A\u0003:fC\u0012\u001c6\r[3nCR!\u0011\u0011AA&\u0011\u0019\t)%\u0005a\u0001u\u0006YqO]5uKN\u001b\u0007.Z7b)\u0019\ty!!\u0015\u0002T!1\u0011Q\t\nA\u0002iDaa\u0015\nA\u0002\u0005\u0005\u0011!\u0007:fC\u0012luN\u001d9iKV\u001cxI]1qQ6+G/\u0019#bi\u0006$B!!\u0017\u0002fA!\u00111LA1\u001b\t\tiFC\u0002\u0002`\t\n\u0001\"\\3uC\u0012\fG/Y\u0005\u0005\u0003G\niFA\u000bN_J\u0004\b.Z;t\u000fJ\f\u0007\u000f['fi\u0006$\u0015\r^1\t\r\u0005\u00153\u00031\u0001{\u0003i9(/\u001b;f\u001b>\u0014\b\u000f[3vg\u001e\u0013\u0018\r\u001d5NKR\fG)\u0019;b)\u0019\ty!a\u001b\u0002n!1\u0011Q\t\u000bA\u0002iDq!a\u001c\u0015\u0001\u0004\tI&A\u000bn_J\u0004\b.Z;t\u000fJ\f\u0007\u000f['fi\u0006$\u0015\r^1\u0002\u001bI,\u0017\r\u001a(pI\u0016$\u0016M\u00197f)!\t)(!(\u0002 \u0006\u0005\u0006\u0003BA<\u0003/sA!!\u001f\u0002\u0014:!\u00111PAG\u001d\u0011\ti(a\"\u000f\t\u0005}\u00141\u0011\b\u0004}\u0005\u0005\u0015\"A\u0016\n\u0007\u0005\u0015%&\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003\u0013\u000bY)A\u0003ta\u0006\u00148NC\u0002\u0002\u0006*JA!a$\u0002\u0012\u0006\u00191/\u001d7\u000b\t\u0005%\u00151R\u0005\u0005\u0003o\t)J\u0003\u0003\u0002\u0010\u0006E\u0015\u0002BAM\u00037\u0013\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\t\u0005]\u0012Q\u0013\u0005\u0007\u0003\u000b*\u0002\u0019\u0001>\t\u000bi+\u0002\u0019A.\t\u000f\u0005\rV\u00031\u0001\u0002&\u0006Y1\u000f]1sWN\u001b\u0007.Z7b!\u0011\t9+a+\u000e\u0005\u0005%&b\u0001'\u0002\u0016&!\u0011QVAU\u0005)\u0019FO];diRK\b/Z\u0001\u000foJLG/\u001a(pI\u0016$\u0016M\u00197f)!\ty!a-\u00026\u0006]\u0006BBA#-\u0001\u0007!\u0010C\u0003[-\u0001\u00071\fC\u0004\u0002:Z\u0001\r!!\u001e\u0002\u000bQ\f'\r\\3\u0002+I,\u0017\r\u001a*fY\u0006$\u0018n\u001c8tQ&\u0004H+\u00192mKRA\u0011QOA`\u0003\u0003\f)\r\u0003\u0004\u0002F]\u0001\rA\u001f\u0005\u0007\u0003\u0007<\u0002\u0019\u0001$\u0002\rI,GnS3z\u0011\u001d\t\u0019k\u0006a\u0001\u0003K\u000bac\u001e:ji\u0016\u0014V\r\\1uS>t7\u000f[5q)\u0006\u0014G.\u001a\u000b\t\u0003\u001f\tY-!4\u0002P\"1\u0011Q\t\rA\u0002iDa!a1\u0019\u0001\u00041\u0005bBA]1\u0001\u0007\u0011QO\u0001\u000bOJ\f\u0007\u000f\u001b(b[\u0016\u001c\u0018\u0001\u00035bg\u001e\u0013\u0018\r\u001d5\u0015\t\u0005]\u0017Q\u001c\t\u0004e\u0005e\u0017bAAng\t9!i\\8mK\u0006t\u0007BBA#5\u0001\u0007!0\u0001\u0004eK2,G/\u001a\u000b\u0005\u0003\u001f\t\u0019\u000f\u0003\u0004\u0002Fm\u0001\rA\u001f\u000b\u0005\u0003O\fi\u000fE\u0002|\u0003SL1!a;}\u00055\u0001&o\u001c9feRLxI]1qQ\"1\u0011q\u001e\u000fA\u0002i\fAA\\1nKR!\u00111_A}!\u0015\u0011\u0014Q_A\u0001\u0013\r\t9p\r\u0002\u0007\u001fB$\u0018n\u001c8\t\r\u0005\u0015S\u00041\u0001{\u0003\u0015\u0019Ho\u001c:f)\u0019\ty!a@\u0003\u0002!1\u0011Q\t\u0010A\u0002iDa! \u0010A\u0002\u0005\u001d\u0018!\u0002:fg\u0016$HCAA\b\u0003Y9\u0018-\u001b;G_J<&/\u001b;f\u0007>l\u0007\u000f\\3uS>tG\u0003\u0002B\u0006\u0005;!B!a\u0004\u0003\u000e!9!q\u0002\u0011A\u0004\tE\u0011AA3d!\u0011\u0011\u0019B!\u0007\u000e\u0005\tU!b\u0001B\fg\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\tm!Q\u0003\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqRDqAa\b!\u0001\u0004\u0011\t#\u0001\u0007xe&$XMR;ukJ,7\u000f\u0005\u0003=9\n\r\u0002C\u0002B\n\u0005K\ty!\u0003\u0003\u0003(\tU!A\u0002$viV\u0014X\r")
public abstract class AbstractPropertyGraphDataSource
implements MorpheusPropertyGraphDataSource {
    private Map<String, MorpheusSchema> schemaCache;
    private Set<String> graphNameCache;

    public static Map<String, CypherType> relColsWithCypherType(PropertyGraphSchema propertyGraphSchema, String string) {
        return AbstractPropertyGraphDataSource$.MODULE$.relColsWithCypherType(propertyGraphSchema, string);
    }

    public static Map<String, CypherType> nodeColsWithCypherType(PropertyGraphSchema propertyGraphSchema, Set<String> set) {
        return AbstractPropertyGraphDataSource$.MODULE$.nodeColsWithCypherType(propertyGraphSchema, set);
    }

    @Override
    public void checkStorable(String name) {
        MorpheusPropertyGraphDataSource.checkStorable$(this, name);
    }

    public abstract MorpheusSession morpheus();

    public abstract StorageFormat tableStorageFormat();

    public Map<String, MorpheusSchema> schemaCache() {
        return this.schemaCache;
    }

    public void schemaCache_$eq(Map<String, MorpheusSchema> x$1) {
        this.schemaCache = x$1;
    }

    public Set<String> graphNameCache() {
        return this.graphNameCache;
    }

    public void graphNameCache_$eq(Set<String> x$1) {
        this.graphNameCache = x$1;
    }

    public abstract List<String> listGraphNames();

    public abstract void deleteGraph(String var1);

    public abstract MorpheusSchema readSchema(String var1);

    public abstract void writeSchema(String var1, MorpheusSchema var2);

    public abstract MorpheusGraphMetaData readMorpheusGraphMetaData(String var1);

    public abstract void writeMorpheusGraphMetaData(String var1, MorpheusGraphMetaData var2);

    public abstract Dataset<Row> readNodeTable(String var1, Set<String> var2, StructType var3);

    public abstract void writeNodeTable(String var1, Set<String> var2, Dataset<Row> var3);

    public abstract Dataset<Row> readRelationshipTable(String var1, String var2, StructType var3);

    public abstract void writeRelationshipTable(String var1, String var2, Dataset<Row> var3);

    public Set<String> graphNames() {
        return this.graphNameCache();
    }

    public boolean hasGraph(String graphName) {
        return this.graphNameCache().contains((Object)new GraphName(graphName));
    }

    public void delete(String graphName) {
        this.deleteGraph(graphName);
        this.schemaCache_$eq((Map<String, MorpheusSchema>)((Map)this.schemaCache().$minus((Object)new GraphName(graphName))));
        this.graphNameCache_$eq((Set<String>)((Set)this.graphNameCache().$minus((Object)new GraphName(graphName))));
    }

    public PropertyGraph graph(String name) {
        if (!this.hasGraph(name)) {
            throw new GraphNotFoundException(new StringBuilder(18).append("Graph with name '").append(new GraphName(name)).append("'").toString(), GraphNotFoundException$.MODULE$.apply$default$2());
        }
        MorpheusSchema morpheusSchema = (MorpheusSchema)this.schema(name).get();
        Set nodeTables = (Set)morpheusSchema.allCombinations().map((Function1 & Serializable & scala.Serializable)combo -> {
            Dataset<Row> df = this.readNodeTable(name, (Set<String>)combo, MorpheusGraphExport$CanonicalTableSparkSchema$.MODULE$.canonicalNodeStructType$extension(MorpheusGraphExport$.MODULE$.CanonicalTableSparkSchema(morpheusSchema), (Set<String>)combo));
            return MorpheusNodeTable$.MODULE$.apply((Set<String>)combo, df);
        }, Set$.MODULE$.canBuildFrom());
        Set relTables = (Set)morpheusSchema.relationshipTypes().map((Function1 & Serializable & scala.Serializable)relType -> {
            Dataset<Row> df = this.readRelationshipTable(name, (String)relType, MorpheusGraphExport$CanonicalTableSparkSchema$.MODULE$.canonicalRelStructType$extension(MorpheusGraphExport$.MODULE$.CanonicalTableSparkSchema(morpheusSchema), (String)relType));
            return MorpheusRelationshipTable$.MODULE$.apply((String)relType, df);
        }, Set$.MODULE$.canBuildFrom());
        return nodeTables.isEmpty() ? this.morpheus().graphs().empty() : this.morpheus().graphs().create((Option<PropertyGraphSchema>)new Some((Object)morpheusSchema), (Seq<ElementTable<SparkTable.DataFrameTable>>)nodeTables.$plus$plus((GenTraversableOnce)relTables).toSeq());
    }

    public Option<MorpheusSchema> schema(String graphName) {
        Option option;
        if (this.schemaCache().contains((Object)new GraphName(graphName))) {
            option = this.schemaCache().get((Object)new GraphName(graphName));
        } else {
            MorpheusSchema s = this.readSchema(graphName);
            this.schemaCache_$eq((Map<String, MorpheusSchema>)this.schemaCache().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new GraphName(graphName)), (Object)s)));
            option = new Some((Object)s);
        }
        return option;
    }

    public void store(String graphName, PropertyGraph graph) {
        this.checkStorable(graphName);
        int poolSize = this.morpheus().sparkSession().sparkContext().statusTracker().getExecutorInfos().length;
        ExecutionContextExecutorService executionContext = ExecutionContext$.MODULE$.fromExecutorService(Executors.newFixedThreadPool(poolSize));
        try {
            RelationalCypherGraph<SparkTable.DataFrameTable> relationalGraph = MorpheusConverters$RichPropertyGraph$.MODULE$.asMorpheus$extension(MorpheusConverters$.MODULE$.RichPropertyGraph(graph));
            MorpheusSchema schema = MorpheusSchema$.MODULE$.MorpheusSchemaConverter(relationalGraph.schema()).asMorpheus();
            this.schemaCache_$eq((Map<String, MorpheusSchema>)this.schemaCache().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new GraphName(graphName)), (Object)schema)));
            this.graphNameCache_$eq((Set<String>)((Set)this.graphNameCache().$plus((Object)new GraphName(graphName))));
            this.writeMorpheusGraphMetaData(graphName, new MorpheusGraphMetaData(this.tableStorageFormat().name()));
            this.writeSchema(graphName, schema);
            Set nodeWrites = (Set)schema.labelCombinations().combos().map((Function1 & Serializable & scala.Serializable)combo -> Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.writeNodeTable(graphName, (Set<String>)combo, MorpheusGraphExport$.MODULE$.CanonicalTableExport(relationalGraph).canonicalNodeTable((Set<String>)combo)), (ExecutionContext)executionContext), Set$.MODULE$.canBuildFrom());
            Set relWrites = (Set)schema.relationshipTypes().map((Function1 & Serializable & scala.Serializable)relType -> Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.writeRelationshipTable(graphName, (String)relType, MorpheusGraphExport$.MODULE$.CanonicalTableExport(relationalGraph).canonicalRelationshipTable((String)relType)), (ExecutionContext)executionContext), Set$.MODULE$.canBuildFrom());
            this.waitForWriteCompletion((Set<Future<BoxedUnit>>)nodeWrites, (ExecutionContext)executionContext);
            this.waitForWriteCompletion((Set<Future<BoxedUnit>>)relWrites, (ExecutionContext)executionContext);
        }
        finally {
            executionContext.shutdown();
        }
    }

    public void reset() {
        this.schemaCache_$eq((Map<String, MorpheusSchema>)Predef$.MODULE$.Map().empty());
        this.graphNameCache_$eq((Set<String>)((TraversableOnce)this.listGraphNames().map((Function1)GraphName$.MODULE$, List$.MODULE$.canBuildFrom())).toSet());
    }

    public void waitForWriteCompletion(Set<Future<BoxedUnit>> writeFutures, ExecutionContext ec) {
        writeFutures.foreach((Function1 & Serializable & scala.Serializable)writeFuture -> {
            AbstractPropertyGraphDataSource.$anonfun$waitForWriteCompletion$1(ec, writeFuture);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$waitForWriteCompletion$2(Try x0$1) {
        Try try_ = x0$1;
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                throw e;
            }
            throw new MatchError((Object)try_);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$waitForWriteCompletion$1(ExecutionContext ec$1, Future writeFuture) {
        Await$.MODULE$.ready((Awaitable)writeFuture, (Duration)Duration$.MODULE$.Inf());
        writeFuture.onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AbstractPropertyGraphDataSource.$anonfun$waitForWriteCompletion$2(x0$1);
            return BoxedUnit.UNIT;
        }, ec$1);
    }

    public AbstractPropertyGraphDataSource() {
        PropertyGraphDataSource.$init$((PropertyGraphDataSource)this);
        MorpheusPropertyGraphDataSource.$init$(this);
        this.schemaCache = Predef$.MODULE$.Map().empty();
        this.graphNameCache = ((TraversableOnce)this.listGraphNames().map((Function1)GraphName$.MODULE$, List$.MODULE$.canBuildFrom())).toSet();
    }
}

