/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.morpheus.api.io.fs;

import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StructType;
import org.opencypher.morpheus.api.MorpheusSession;
import org.opencypher.morpheus.api.io.AbstractPropertyGraphDataSource;
import org.opencypher.morpheus.api.io.StorageFormat;
import org.opencypher.morpheus.api.io.fs.DefaultGraphDirectoryStructure;
import org.opencypher.morpheus.api.io.fs.DefaultGraphDirectoryStructure$;
import org.opencypher.morpheus.api.io.fs.DefaultGraphDirectoryStructure$StringPath$;
import org.opencypher.morpheus.api.io.fs.FSGraphSource$;
import org.opencypher.morpheus.api.io.fs.HadoopFSHelpers$;
import org.opencypher.morpheus.api.io.json.JsonSerialization;
import org.opencypher.morpheus.api.io.metadata.MorpheusGraphMetaData;
import org.opencypher.morpheus.api.io.util.HiveTableName$;
import org.opencypher.morpheus.schema.MorpheusSchema;
import org.opencypher.okapi.api.graph.GraphElementType;
import org.opencypher.okapi.api.graph.Node$;
import org.opencypher.okapi.api.graph.Relationship$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tMb\u0001\u0002\u0014(\u0001QB\u0001b\u0010\u0001\u0003\u0006\u0004%\t\u0001\u0011\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u0003\"Aq\n\u0001BC\u0002\u0013\u0005\u0001\u000b\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003R\u0011!)\u0006A!b\u0001\n\u00031\u0006\u0002C.\u0001\u0005\u0003\u0005\u000b\u0011B,\t\u0011q\u0003!Q1A\u0005\u0002uC\u0001B\u0019\u0001\u0003\u0002\u0003\u0006IA\u0018\u0005\t]\u0001\u0011)\u0019!C\"G\"A\u0001\u000e\u0001B\u0001B\u0003%A\rC\u0003j\u0001\u0011\u0005!\u000eC\u0004t\u0001\t\u0007I\u0011\u0003;\t\ra\u0004\u0001\u0015!\u0003v\u0011!I\b\u0001#b\u0001\n#Q\bbBA\u0005\u0001\u0011E\u00111\u0002\u0005\b\u0003G\u0001A\u0011CA\u0013\u0011\u001d\ty\u0003\u0001C\t\u0003cAq!!\u000e\u0001\t#\t9\u0004C\u0004\u0002@\u0001!\t\"!\u0011\t\u000f\u0005e\u0004\u0001\"\u0005\u0002|!9\u00111\u0011\u0001\u0005R\u0005\u0015\u0005bBAD\u0001\u0011E\u0013\u0011\u0012\u0005\b\u0003C\u0003A\u0011KAR\u0011\u001d\t)\f\u0001C)\u0003oCq!a0\u0001\t#\n\t\rC\u0004\u0002L\u0002!\t&!4\t\u000f\u0005U\u0007\u0001\"\u0003\u0002X\"9\u00111\u001d\u0001\u0005\n\u0005\u0015\bbBAu\u0001\u0011E\u00131\u001e\u0005\b\u0003_\u0004A\u0011KAy\u0011\u001d\t9\u0010\u0001C)\u0003sDq!!@\u0001\t#\nypB\u0005\u0003\b\u001d\n\t\u0011#\u0001\u0003\n\u0019AaeJA\u0001\u0012\u0003\u0011Y\u0001\u0003\u0004jE\u0011\u0005!1\u0003\u0005\n\u0005+\u0011\u0013\u0013!C\u0001\u0005/A\u0011B!\f##\u0003%\tAa\f\u0003\u001b\u0019\u001bvI]1qQN{WO]2f\u0015\tA\u0013&\u0001\u0002gg*\u0011!fK\u0001\u0003S>T!\u0001L\u0017\u0002\u0007\u0005\u0004\u0018N\u0003\u0002/_\u0005AQn\u001c:qQ\u0016,8O\u0003\u00021c\u0005Qq\u000e]3oGf\u0004\b.\u001a:\u000b\u0003I\n1a\u001c:h\u0007\u0001\u00192\u0001A\u001b:!\t1t'D\u0001*\u0013\tA\u0014FA\u0010BEN$(/Y2u!J|\u0007/\u001a:us\u001e\u0013\u0018\r\u001d5ECR\f7k\\;sG\u0016\u0004\"AO\u001f\u000e\u0003mR!\u0001P\u0015\u0002\t)\u001cxN\\\u0005\u0003}m\u0012\u0011CS:p]N+'/[1mSj\fG/[8o\u0003!\u0011xn\u001c;QCRDW#A!\u0011\u0005\t[eBA\"J!\t!u)D\u0001F\u0015\t15'\u0001\u0004=e>|GO\u0010\u0006\u0002\u0011\u0006)1oY1mC&\u0011!jR\u0001\u0007!J,G-\u001a4\n\u00051k%AB*ue&twM\u0003\u0002K\u000f\u0006I!o\\8u!\u0006$\b\u000eI\u0001\u0013i\u0006\u0014G.Z*u_J\fw-\u001a$pe6\fG/F\u0001R!\t1$+\u0003\u0002TS\ti1\u000b^8sC\u001e,gi\u001c:nCR\f1\u0003^1cY\u0016\u001cFo\u001c:bO\u00164uN]7bi\u0002\n\u0001\u0003[5wK\u0012\u000bG/\u00192bg\u0016t\u0015-\\3\u0016\u0003]\u00032\u0001W-B\u001b\u00059\u0015B\u0001.H\u0005\u0019y\u0005\u000f^5p]\u0006\t\u0002.\u001b<f\t\u0006$\u0018MY1tK:\u000bW.\u001a\u0011\u0002\u001b\u0019LG.Z:QKJ$\u0016M\u00197f+\u0005q\u0006c\u0001-Z?B\u0011\u0001\fY\u0005\u0003C\u001e\u00131!\u00138u\u000391\u0017\u000e\\3t!\u0016\u0014H+\u00192mK\u0002*\u0012\u0001\u001a\t\u0003K\u001al\u0011aK\u0005\u0003O.\u0012q\"T8sa\",Wo]*fgNLwN\\\u0001\n[>\u0014\b\u000f[3vg\u0002\na\u0001P5oSRtD#B6paF\u0014HC\u00017o!\ti\u0007!D\u0001(\u0011\u0015q3\u0002q\u0001e\u0011\u0015y4\u00021\u0001B\u0011\u0015y5\u00021\u0001R\u0011\u001d)6\u0002%AA\u0002]Cq\u0001X\u0006\u0011\u0002\u0003\u0007a,\u0001\neSJ,7\r^8ssN#(/^2ukJ,W#A;\u0011\u000554\u0018BA<(\u0005y!UMZ1vYR<%/\u00199i\t&\u0014Xm\u0019;pef\u001cFO];diV\u0014X-A\neSJ,7\r^8ssN#(/^2ukJ,\u0007%\u0001\u0006gS2,7+_:uK6,\u0012a\u001f\t\u0004y\u0006\u0015Q\"A?\u000b\u0005!r(bA@\u0002\u0002\u00051\u0001.\u00193p_BT1!a\u00012\u0003\u0019\t\u0007/Y2iK&\u0019\u0011qA?\u0003\u0015\u0019KG.Z*zgR,W.A\bmSN$H)\u001b:fGR|'/[3t)\u0011\ti!a\b\u0011\u000b\u0005=\u0011\u0011D!\u000f\t\u0005E\u0011Q\u0003\b\u0004\t\u0006M\u0011\"\u0001%\n\u0007\u0005]q)A\u0004qC\u000e\\\u0017mZ3\n\t\u0005m\u0011Q\u0004\u0002\u0005\u0019&\u001cHOC\u0002\u0002\u0018\u001dCa!!\t\u0010\u0001\u0004\t\u0015\u0001\u00029bi\"\fq\u0002Z3mKR,G)\u001b:fGR|'/\u001f\u000b\u0005\u0003O\ti\u0003E\u0002Y\u0003SI1!a\u000bH\u0005\u0011)f.\u001b;\t\r\u0005\u0005\u0002\u00031\u0001B\u0003!\u0011X-\u00193GS2,GcA!\u00024!1\u0011\u0011E\tA\u0002\u0005\u000b\u0011b\u001e:ji\u00164\u0015\u000e\\3\u0015\r\u0005\u001d\u0012\u0011HA\u001e\u0011\u0019\t\tC\u0005a\u0001\u0003\"1\u0011Q\b\nA\u0002\u0005\u000bqaY8oi\u0016tG/A\u0005sK\u0006$G+\u00192mKR1\u00111IA4\u0003S\u0002B!!\u0012\u0002b9!\u0011qIA/\u001d\u0011\tI%a\u0016\u000f\t\u0005-\u00131\u000b\b\u0005\u0003\u001b\n\tFD\u0002E\u0003\u001fJ\u0011AM\u0005\u0004\u0003\u0007\t\u0014\u0002BA+\u0003\u0003\tQa\u001d9be.LA!!\u0017\u0002\\\u0005\u00191/\u001d7\u000b\t\u0005U\u0013\u0011A\u0005\u0005\u0003/\tyF\u0003\u0003\u0002Z\u0005m\u0013\u0002BA2\u0003K\u0012\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\t\u0005]\u0011q\f\u0005\u0007\u0003C\u0019\u0002\u0019A!\t\u000f\u0005-4\u00031\u0001\u0002n\u000511o\u00195f[\u0006\u0004B!a\u001c\u0002v5\u0011\u0011\u0011\u000f\u0006\u0005\u0003g\ny&A\u0003usB,7/\u0003\u0003\u0002x\u0005E$AC*ueV\u001cG\u000fV=qK\u0006QqO]5uKR\u000b'\r\\3\u0015\r\u0005\u001d\u0012QPA@\u0011\u0019\t\t\u0003\u0006a\u0001\u0003\"9\u0011\u0011\u0011\u000bA\u0002\u0005\r\u0013!\u0002;bE2,\u0017A\u00047jgR<%/\u00199i\u001d\u0006lWm]\u000b\u0003\u0003\u001b\t1\u0002Z3mKR,wI]1qQR!\u0011qEAF\u0011\u001d\tiI\u0006a\u0001\u0003\u001f\u000b\u0011b\u001a:ba\"t\u0015-\\3\u0011\t\u0005E\u0015QT\u0007\u0003\u0003'SA!!&\u0002\u0018\u0006)qM]1qQ*\u0019A&!'\u000b\u0007\u0005mu&A\u0003pW\u0006\u0004\u0018.\u0003\u0003\u0002 \u0006M%!C$sCBDg*Y7f\u00035\u0011X-\u00193O_\u0012,G+\u00192mKRA\u00111IAS\u0003O\u000b\t\fC\u0004\u0002\u000e^\u0001\r!a$\t\u000f\u0005%v\u00031\u0001\u0002,\u00061A.\u00192fYN\u0004BAQAW\u0003&\u0019\u0011qV'\u0003\u0007M+G\u000fC\u0004\u00024^\u0001\r!!\u001c\u0002\u0017M\u0004\u0018M]6TG\",W.Y\u0001\u000foJLG/\u001a(pI\u0016$\u0016M\u00197f)!\t9#!/\u0002<\u0006u\u0006bBAG1\u0001\u0007\u0011q\u0012\u0005\b\u0003SC\u0002\u0019AAV\u0011\u001d\t\t\t\u0007a\u0001\u0003\u0007\nQC]3bIJ+G.\u0019;j_:\u001c\b.\u001b9UC\ndW\r\u0006\u0005\u0002D\u0005\r\u0017QYAe\u0011\u001d\ti)\u0007a\u0001\u0003\u001fCa!a2\u001a\u0001\u0004\t\u0015A\u0002:fY.+\u0017\u0010C\u0004\u00024f\u0001\r!!\u001c\u0002-]\u0014\u0018\u000e^3SK2\fG/[8og\"L\u0007\u000fV1cY\u0016$\u0002\"a\n\u0002P\u0006E\u00171\u001b\u0005\b\u0003\u001bS\u0002\u0019AAH\u0011\u0019\t9M\u0007a\u0001\u0003\"9\u0011\u0011\u0011\u000eA\u0002\u0005\r\u0013AD<sSR,\u0007*\u001b<f)\u0006\u0014G.\u001a\u000b\t\u0003O\tI.!8\u0002b\"1\u00111\\\u000eA\u0002\u0005\u000b1\u0002]1uQR{G+\u00192mK\"1\u0011q\\\u000eA\u0002\u0005\u000bQ\u0002[5wKR\u000b'\r\\3OC6,\u0007bBA67\u0001\u0007\u0011QN\u0001\u0013I\u0016dW\r^3ISZ,G)\u0019;bE\u0006\u001cX\r\u0006\u0003\u0002(\u0005\u001d\bbBAG9\u0001\u0007\u0011qR\u0001\u000fe\u0016\fGMS:p]N\u001b\u0007.Z7b)\r\t\u0015Q\u001e\u0005\b\u0003\u001bk\u0002\u0019AAH\u0003=9(/\u001b;f\u0015N|gnU2iK6\fGCBA\u0014\u0003g\f)\u0010C\u0004\u0002\u000ez\u0001\r!a$\t\r\u0005-d\u00041\u0001B\u0003u\u0011X-\u00193Kg>tWj\u001c:qQ\u0016,8o\u0012:ba\"lU\r^1ECR\fGcA!\u0002|\"9\u0011QR\u0010A\u0002\u0005=\u0015AH<sSR,'j]8o\u001b>\u0014\b\u000f[3vg\u001e\u0013\u0018\r\u001d5NKR\fG)\u0019;b)\u0019\t9C!\u0001\u0003\u0004!9\u0011Q\u0012\u0011A\u0002\u0005=\u0005B\u0002B\u0003A\u0001\u0007\u0011)A\u000bn_J\u0004\b.Z;t\u000fJ\f\u0007\u000f['fi\u0006$\u0015\r^1\u0002\u001b\u0019\u001bvI]1qQN{WO]2f!\ti'eE\u0002#\u0005\u001b\u00012\u0001\u0017B\b\u0013\r\u0011\tb\u0012\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\t%\u0011a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0006\u0002\u0003\u001a)\u001aqKa\u0007,\u0005\tu\u0001\u0003\u0002B\u0010\u0005Si!A!\t\u000b\t\t\r\"QE\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\nH\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005W\u0011\tCA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"TC\u0001B\u0019U\rq&1\u0004")
public class FSGraphSource
extends AbstractPropertyGraphDataSource
implements JsonSerialization {
    private FileSystem fileSystem;
    private final String rootPath;
    private final StorageFormat tableStorageFormat;
    private final Option<String> hiveDatabaseName;
    private final Option<Object> filesPerTable;
    private final MorpheusSession morpheus;
    private final DefaultGraphDirectoryStructure directoryStructure;
    private volatile boolean bitmap$0;

    public static Option<Object> $lessinit$greater$default$4() {
        return FSGraphSource$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<String> $lessinit$greater$default$3() {
        return FSGraphSource$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public MorpheusSchema readSchema(String graphName) {
        return JsonSerialization.readSchema$(this, graphName);
    }

    @Override
    public void writeSchema(String graphName, MorpheusSchema schema) {
        JsonSerialization.writeSchema$(this, graphName, schema);
    }

    @Override
    public MorpheusGraphMetaData readMorpheusGraphMetaData(String graphName) {
        return JsonSerialization.readMorpheusGraphMetaData$(this, graphName);
    }

    @Override
    public void writeMorpheusGraphMetaData(String graphName, MorpheusGraphMetaData morpheusGraphMetaData) {
        JsonSerialization.writeMorpheusGraphMetaData$(this, graphName, morpheusGraphMetaData);
    }

    public String rootPath() {
        return this.rootPath;
    }

    @Override
    public StorageFormat tableStorageFormat() {
        return this.tableStorageFormat;
    }

    public Option<String> hiveDatabaseName() {
        return this.hiveDatabaseName;
    }

    public Option<Object> filesPerTable() {
        return this.filesPerTable;
    }

    @Override
    public MorpheusSession morpheus() {
        return this.morpheus;
    }

    public DefaultGraphDirectoryStructure directoryStructure() {
        return this.directoryStructure;
    }

    private FileSystem fileSystem$lzycompute() {
        FSGraphSource fSGraphSource = this;
        synchronized (fSGraphSource) {
            if (!this.bitmap$0) {
                this.fileSystem = FileSystem.get((URI)new URI(this.rootPath()), (Configuration)this.morpheus().sparkSession().sparkContext().hadoopConfiguration());
                this.bitmap$0 = true;
            }
        }
        return this.fileSystem;
    }

    public FileSystem fileSystem() {
        return !this.bitmap$0 ? this.fileSystem$lzycompute() : this.fileSystem;
    }

    public List<String> listDirectories(String path) {
        return HadoopFSHelpers$.MODULE$.RichHadoopFileSystem(this.fileSystem()).listDirectories(path);
    }

    public void deleteDirectory(String path) {
        HadoopFSHelpers$.MODULE$.RichHadoopFileSystem(this.fileSystem()).deleteDirectory(path);
    }

    public String readFile(String path) {
        return HadoopFSHelpers$.MODULE$.RichHadoopFileSystem(this.fileSystem()).readFile(path);
    }

    public void writeFile(String path, String content) {
        HadoopFSHelpers$.MODULE$.RichHadoopFileSystem(this.fileSystem()).writeFile(path, content);
    }

    public Dataset<Row> readTable(String path, StructType schema) {
        return this.morpheus().sparkSession().read().format(this.tableStorageFormat().name()).schema(schema).load(path);
    }

    public void writeTable(String path, Dataset<Row> table) {
        Dataset dataset;
        Option<Object> option = this.filesPerTable();
        if (None$.MODULE$.equals(option)) {
            dataset = table;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            int numFiles = BoxesRunTime.unboxToInt((Object)some.value());
            dataset = table.coalesce(numFiles);
        } else {
            throw new MatchError(option);
        }
        Dataset coalescedTable = dataset;
        List list = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])coalescedTable.columns())).collect((PartialFunction)new scala.Serializable(null, coalescedTable){
            public static final long serialVersionUID = 0L;
            private final Dataset coalescedTable$1;

            public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                DataType dataType = this.coalescedTable$1.schema().apply(A1).dataType();
                NullType$ nullType$ = NullType$.MODULE$;
                Object object = (dataType == null ? nullType$ != null : !dataType.equals(nullType$)) ? A1 : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(String x1) {
                String string = x1;
                DataType dataType = this.coalescedTable$1.schema().apply(string).dataType();
                NullType$ nullType$ = NullType$.MODULE$;
                boolean bl = dataType == null ? nullType$ != null : !dataType.equals(nullType$);
                return bl;
            }
            {
                this.coalescedTable$1 = coalescedTable$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toList();
        if (!(list instanceof .colon.colon)) {
            throw new MatchError((Object)list);
        }
        .colon.colon colon2 = (.colon.colon)list;
        String h = (String)colon2.head();
        List t = colon2.tl$access$1();
        Tuple2 tuple2 = new Tuple2((Object)h, (Object)t);
        Tuple2 tuple22 = tuple2;
        String h2 = (String)tuple22._1();
        List t2 = (List)tuple22._2();
        coalescedTable.select(h2, (Seq)t2).write().format(this.tableStorageFormat().name()).save(path);
    }

    @Override
    public List<String> listGraphNames() {
        return (List)((List)((List)this.traverse$1(this.rootPath()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.substring(this.rootPath().length()), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.replace(DefaultGraphDirectoryStructure$.MODULE$.pathSeparator(), "."), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.substring(1), List$.MODULE$.canBuildFrom());
    }

    @Override
    public void deleteGraph(String graphName) {
        block0: {
            this.deleteDirectory(this.directoryStructure().pathToGraphDirectory(graphName));
            if (!this.hiveDatabaseName().isDefined()) break block0;
            this.deleteHiveDatabase(graphName);
        }
    }

    @Override
    public Dataset<Row> readNodeTable(String graphName, Set<String> labels, StructType sparkSchema) {
        return this.readTable(this.directoryStructure().pathToNodeTable(graphName, labels), sparkSchema);
    }

    @Override
    public void writeNodeTable(String graphName, Set<String> labels, Dataset<Row> table) {
        block0: {
            this.writeTable(this.directoryStructure().pathToNodeTable(graphName, labels), table);
            if (!this.hiveDatabaseName().isDefined()) break block0;
            String hiveNodeTableName = HiveTableName$.MODULE$.apply((String)this.hiveDatabaseName().get(), graphName, (GraphElementType)Node$.MODULE$, labels);
            this.writeHiveTable(this.directoryStructure().pathToNodeTable(graphName, labels), hiveNodeTableName, table.schema());
        }
    }

    @Override
    public Dataset<Row> readRelationshipTable(String graphName, String relKey, StructType sparkSchema) {
        return this.readTable(this.directoryStructure().pathToRelationshipTable(graphName, relKey), sparkSchema);
    }

    @Override
    public void writeRelationshipTable(String graphName, String relKey, Dataset<Row> table) {
        block0: {
            this.writeTable(this.directoryStructure().pathToRelationshipTable(graphName, relKey), table);
            if (!this.hiveDatabaseName().isDefined()) break block0;
            String hiveRelationshipTableName = HiveTableName$.MODULE$.apply((String)this.hiveDatabaseName().get(), graphName, (GraphElementType)Relationship$.MODULE$, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{relKey}))));
            this.writeHiveTable(this.directoryStructure().pathToRelationshipTable(graphName, relKey), hiveRelationshipTableName, table.schema());
        }
    }

    private void writeHiveTable(String pathToTable, String hiveTableName, StructType schema) {
        this.morpheus().sparkSession().catalog().createTable(hiveTableName, this.tableStorageFormat().name(), schema, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)pathToTable)})));
        this.morpheus().sparkSession().catalog().refreshTable(hiveTableName);
    }

    private void deleteHiveDatabase(String graphName) {
        MorpheusSchema graphSchema = (MorpheusSchema)this.schema(graphName).get();
        Set labelCombinations = graphSchema.labelCombinations().combos();
        Set<String> relTypes = graphSchema.relationshipTypes();
        labelCombinations.foreach((Function1 & Serializable & scala.Serializable)combo -> {
            String tableName = HiveTableName$.MODULE$.apply((String)this.hiveDatabaseName().get(), graphName, (GraphElementType)Node$.MODULE$, (Set<String>)combo);
            return this.morpheus().sparkSession().sql(new StringBuilder(21).append("DROP TABLE IF EXISTS ").append(tableName).toString());
        });
        relTypes.foreach((Function1 & Serializable & scala.Serializable)relType -> {
            String tableName = HiveTableName$.MODULE$.apply((String)this.hiveDatabaseName().get(), graphName, (GraphElementType)Relationship$.MODULE$, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{relType}))));
            return this.morpheus().sparkSession().sql(new StringBuilder(21).append("DROP TABLE IF EXISTS ").append(tableName).toString());
        });
    }

    @Override
    public String readJsonSchema(String graphName) {
        return this.readFile(this.directoryStructure().pathToGraphSchema(graphName));
    }

    @Override
    public void writeJsonSchema(String graphName, String schema) {
        this.writeFile(this.directoryStructure().pathToGraphSchema(graphName), schema);
    }

    @Override
    public String readJsonMorpheusGraphMetaData(String graphName) {
        return this.readFile(this.directoryStructure().pathToMorpheusMetaData(graphName));
    }

    @Override
    public void writeJsonMorpheusGraphMetaData(String graphName, String morpheusGraphMetaData) {
        this.writeFile(this.directoryStructure().pathToMorpheusMetaData(graphName), morpheusGraphMetaData);
    }

    private final List traverse$1(String parent) {
        List<String> children = this.listDirectories(parent);
        return children.contains((Object)DefaultGraphDirectoryStructure$.MODULE$.nodeTablesDirectoryName()) || children.contains((Object)DefaultGraphDirectoryStructure$.MODULE$.relationshipTablesDirectoryName()) ? new .colon.colon((Object)parent, (List)Nil$.MODULE$) : (List)children.flatMap((Function1 & Serializable & scala.Serializable)child -> this.traverse$1(DefaultGraphDirectoryStructure$StringPath$.MODULE$.$div$extension(DefaultGraphDirectoryStructure$.MODULE$.StringPath(parent), (String)child)), List$.MODULE$.canBuildFrom());
    }

    public FSGraphSource(String rootPath, StorageFormat tableStorageFormat, Option<String> hiveDatabaseName, Option<Object> filesPerTable, MorpheusSession morpheus) {
        this.rootPath = rootPath;
        this.tableStorageFormat = tableStorageFormat;
        this.hiveDatabaseName = hiveDatabaseName;
        this.filesPerTable = filesPerTable;
        this.morpheus = morpheus;
        JsonSerialization.$init$(this);
        this.directoryStructure = new DefaultGraphDirectoryStructure(rootPath);
    }
}

