/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.morpheus.impl.temporal;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalField;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.scala.Logger$;
import org.apache.logging.log4j.scala.Logging;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.opencypher.morpheus.impl.temporal.TemporalUdfs$;
import org.opencypher.okapi.impl.exception.UnsupportedOperationException;
import org.opencypher.okapi.impl.exception.UnsupportedOperationException$;
import scala.Function1;
import scala.Function2;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class TemporalUdfs$
implements Logging {
    public static TemporalUdfs$ MODULE$;
    private final UserDefinedFunction dateAdd;
    private final UserDefinedFunction dateSubtract;
    private final ExtendedLogger logger;

    static {
        new TemporalUdfs$();
    }

    public ExtendedLogger logger() {
        return this.logger;
    }

    public void org$apache$logging$log4j$scala$Logging$_setter_$logger_$eq(ExtendedLogger x$1) {
        this.logger = x$1;
    }

    public UserDefinedFunction dateAdd() {
        return this.dateAdd;
    }

    public UserDefinedFunction dateSubtract() {
        return this.dateSubtract;
    }

    public <I> UserDefinedFunction weekYear(TypeTags.TypeTag<I> evidence$1) {
        return this.dateAccessor(IsoFields.WEEK_BASED_YEAR, evidence$1);
    }

    public <I> UserDefinedFunction dayOfQuarter(TypeTags.TypeTag<I> evidence$2) {
        return this.dateAccessor(IsoFields.DAY_OF_QUARTER, evidence$2);
    }

    public <I> UserDefinedFunction dayOfWeek(TypeTags.TypeTag<I> evidence$3) {
        return this.dateAccessor(ChronoField.DAY_OF_WEEK, evidence$3);
    }

    public <I> UserDefinedFunction milliseconds(TypeTags.TypeTag<I> evidence$4) {
        return this.timeAccessor(ChronoField.MILLI_OF_SECOND, evidence$4);
    }

    public <I> UserDefinedFunction microseconds(TypeTags.TypeTag<I> evidence$5) {
        return this.timeAccessor(ChronoField.MICRO_OF_SECOND, evidence$5);
    }

    public UserDefinedFunction durationAccessor(String accessor) {
        public final class Org_opencypher_morpheus_impl_temporal_TemporalUdfs$$typecreator2$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.unsafe.types.CalendarInterval").asType().toTypeConstructor();
            }

            public Org_opencypher_morpheus_impl_temporal_TemporalUdfs$$typecreator2$2() {
            }
        }
        public final class Org_opencypher_morpheus_impl_temporal_TemporalUdfs$$typecreator1$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("java.lang.Long").asType().toTypeConstructor();
            }

            public Org_opencypher_morpheus_impl_temporal_TemporalUdfs$$typecreator1$2() {
            }
        }
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        return functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)duration -> {
            Long l;
            if (duration == null) {
                l = null;
            } else {
                long l2;
                long days = duration.microseconds / 86400000000L;
                long daysInMicros = days * 86400000000L;
                String string = accessor;
                if ("years".equals(string)) {
                    l2 = duration.months / 12;
                } else if ("quarters".equals(string)) {
                    l2 = duration.months / 3;
                } else if ("months".equals(string)) {
                    l2 = duration.months;
                } else if ("weeks".equals(string)) {
                    l2 = duration.microseconds / 86400000000L / 7L;
                } else if ("days".equals(string)) {
                    l2 = duration.microseconds / 86400000000L;
                } else if ("hours".equals(string)) {
                    l2 = (duration.microseconds - daysInMicros) / 3600000000L;
                } else if ("minutes".equals(string)) {
                    l2 = (duration.microseconds - daysInMicros) / 60000000L;
                } else if ("seconds".equals(string)) {
                    l2 = (duration.microseconds - daysInMicros) / 1000000L;
                } else if ("milliseconds".equals(string)) {
                    l2 = (duration.microseconds - daysInMicros) / 1000L;
                } else if ("microseconds".equals(string)) {
                    l2 = duration.microseconds - daysInMicros;
                } else if ("quartersofyear".equals(string)) {
                    l2 = duration.months / 3 % 4;
                } else if ("monthsofquarter".equals(string)) {
                    l2 = duration.months % 3;
                } else if ("monthsofyear".equals(string)) {
                    l2 = duration.months % 12;
                } else if ("daysofweek".equals(string)) {
                    l2 = duration.microseconds / 86400000000L % 7L;
                } else if ("minutesofhour".equals(string)) {
                    l2 = (duration.microseconds - daysInMicros) / 60000000L % 60L;
                } else if ("secondsofminute".equals(string)) {
                    l2 = (duration.microseconds - daysInMicros) / 1000000L % 60L;
                } else if ("millisecondsofsecond".equals(string)) {
                    l2 = (duration.microseconds - daysInMicros) / 1000L % 1000L;
                } else if ("microsecondsofsecond".equals(string)) {
                    l2 = (duration.microseconds - daysInMicros) % 1000000L;
                } else {
                    throw new UnsupportedOperationException(new StringBuilder(27).append("Unknown Duration accessor: ").append(string).toString(), UnsupportedOperationException$.MODULE$.apply$default$2());
                }
                long l3 = l2;
                l = new Long(l3);
            }
            return l;
        }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_opencypher_morpheus_impl_temporal_TemporalUdfs$$typecreator1$2()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_opencypher_morpheus_impl_temporal_TemporalUdfs$$typecreator2$2()));
    }

    private <I> UserDefinedFunction dateAccessor(TemporalField accessor, TypeTags.TypeTag<I> evidence$6) {
        return functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToLong((long)TemporalUdfs$.$anonfun$dateAccessor$1(accessor, x0$1)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Long(), evidence$6);
    }

    private <I> UserDefinedFunction timeAccessor(TemporalField accessor, TypeTags.TypeTag<I> evidence$7) {
        return functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToLong((long)TemporalUdfs$.$anonfun$timeAccessor$1(accessor, x0$1)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Long(), evidence$7);
    }

    public static final /* synthetic */ long $anonfun$dateAccessor$1(TemporalField accessor$2, Object x0$1) {
        long l;
        Object object = x0$1;
        if (object instanceof Date) {
            Date date = (Date)object;
            l = date.toLocalDate().get(accessor$2);
        } else if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            l = timestamp.toLocalDateTime().get(accessor$2);
        } else {
            throw new UnsupportedOperationException(new StringBuilder(41).append("Date Accessor '").append(accessor$2).append("' is not supported for '").append(object).append("'.").toString(), UnsupportedOperationException$.MODULE$.apply$default$2());
        }
        return l;
    }

    public static final /* synthetic */ long $anonfun$timeAccessor$1(TemporalField accessor$3, Object x0$1) {
        Object object = x0$1;
        if (!(object instanceof Timestamp)) {
            throw new UnsupportedOperationException(new StringBuilder(41).append("Time Accessor '").append(accessor$3).append("' is not supported for '").append(object).append("'.").toString(), UnsupportedOperationException$.MODULE$.apply$default$2());
        }
        Timestamp timestamp = (Timestamp)object;
        long l = timestamp.toLocalDateTime().get(accessor$3);
        return l;
    }

    private TemporalUdfs$() {
        public final class Org_opencypher_morpheus_impl_temporal_TemporalUdfs$$typecreator6$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.unsafe.types.CalendarInterval").asType().toTypeConstructor();
            }

            public Org_opencypher_morpheus_impl_temporal_TemporalUdfs$$typecreator6$1() {
            }
        }
        public final class Org_opencypher_morpheus_impl_temporal_TemporalUdfs$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("java.sql.Date").asType().toTypeConstructor();
            }

            public Org_opencypher_morpheus_impl_temporal_TemporalUdfs$$typecreator5$1() {
            }
        }
        public final class Org_opencypher_morpheus_impl_temporal_TemporalUdfs$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("java.sql.Date").asType().toTypeConstructor();
            }

            public Org_opencypher_morpheus_impl_temporal_TemporalUdfs$$typecreator4$1() {
            }
        }
        public final class Org_opencypher_morpheus_impl_temporal_TemporalUdfs$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.unsafe.types.CalendarInterval").asType().toTypeConstructor();
            }

            public Org_opencypher_morpheus_impl_temporal_TemporalUdfs$$typecreator3$1() {
            }
        }
        public final class Org_opencypher_morpheus_impl_temporal_TemporalUdfs$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("java.sql.Date").asType().toTypeConstructor();
            }

            public Org_opencypher_morpheus_impl_temporal_TemporalUdfs$$typecreator2$1() {
            }
        }
        public final class Org_opencypher_morpheus_impl_temporal_TemporalUdfs$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("java.sql.Date").asType().toTypeConstructor();
            }

            public Org_opencypher_morpheus_impl_temporal_TemporalUdfs$$typecreator1$1() {
            }
        }
        MODULE$ = this;
        Logging.$init$((Logging)this);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        this.dateAdd = functions$.MODULE$.udf((Function2 & Serializable & scala.Serializable)(date, interval) -> {
            Date date2;
            if (date == null || interval == null) {
                date2 = null;
            } else {
                BoxedUnit boxedUnit;
                long days = interval.microseconds / 86400000000L;
                if (interval.microseconds % 86400000000L != 0L) {
                    if (MODULE$.logger().isEnabled(Level.WARN)) {
                        Logger$.MODULE$.logMessage$extension1(MODULE$.logger(), Level.WARN, null, (CharSequence)"Arithmetic with Date and Duration can lead to incorrect results when sub-day values are present.", null);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                LocalDate reducedLocalDate = date.toLocalDate().plusMonths(interval.months).plusDays(days);
                date2 = Date.valueOf(reducedLocalDate);
            }
            return date2;
        }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_opencypher_morpheus_impl_temporal_TemporalUdfs$$typecreator1$1()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_opencypher_morpheus_impl_temporal_TemporalUdfs$$typecreator2$1()), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_opencypher_morpheus_impl_temporal_TemporalUdfs$$typecreator3$1()));
        JavaUniverse $u4 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u5 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m5 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u6 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m6 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        this.dateSubtract = functions$.MODULE$.udf((Function2 & Serializable & scala.Serializable)(date, interval) -> {
            Date date2;
            if (date == null || interval == null) {
                date2 = null;
            } else {
                BoxedUnit boxedUnit;
                long days = interval.microseconds / 86400000000L;
                if (interval.microseconds % 86400000000L != 0L) {
                    if (MODULE$.logger().isEnabled(Level.WARN)) {
                        Logger$.MODULE$.logMessage$extension1(MODULE$.logger(), Level.WARN, null, (CharSequence)"Arithmetic with Date and Duration can lead to incorrect results when sub-day values are present.", null);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                LocalDate reducedLocalDate = date.toLocalDate().minusMonths(interval.months).minusDays(days);
                date2 = Date.valueOf(reducedLocalDate);
            }
            return date2;
        }, ((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_opencypher_morpheus_impl_temporal_TemporalUdfs$$typecreator4$1()), ((TypeTags)$u5).TypeTag().apply((Mirror)$m5, (TypeCreator)new Org_opencypher_morpheus_impl_temporal_TemporalUdfs$$typecreator5$1()), ((TypeTags)$u6).TypeTag().apply((Mirror)$m6, (TypeCreator)new Org_opencypher_morpheus_impl_temporal_TemporalUdfs$$typecreator6$1()));
    }
}

