/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.okapi.impl.io;

import org.mockito.Mockito;
import org.opencypher.okapi.ApiBaseTest;
import org.opencypher.okapi.api.graph.GraphName;
import org.opencypher.okapi.api.graph.PropertyGraph;
import org.opencypher.okapi.api.schema.Schema;
import org.opencypher.okapi.api.schema.Schema$;
import org.opencypher.okapi.impl.exception.GraphNotFoundException;
import org.opencypher.okapi.impl.io.SessionGraphDataSource;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]1A!\u0001\u0002\u0001\u001b\tQ2+Z:tS>twI]1qQ\u0012\u000bG/Y*pkJ\u001cW\rV3ti*\u00111\u0001B\u0001\u0003S>T!!\u0002\u0004\u0002\t%l\u0007\u000f\u001c\u0006\u0003\u000f!\tQa\\6ba&T!!\u0003\u0006\u0002\u0015=\u0004XM\\2za\",'OC\u0001\f\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010!5\ta!\u0003\u0002\u0012\r\tY\u0011\t]5CCN,G+Z:u\u0011\u0015\u0019\u0002\u0001\"\u0001\u0015\u0003\u0019a\u0014N\\5u}Q\tQ\u0003\u0005\u0002\u0017\u00015\t!\u0001")
public class SessionGraphDataSourceTest
extends ApiBaseTest {
    public SessionGraphDataSourceTest() {
        this.it().apply("hasGraph should return true for existing graph", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionGraphDataSourceTest $outer;

            public final Assertion apply() {
                SessionGraphDataSource source = new SessionGraphDataSource();
                String testGraphName = "test";
                source.store(testGraphName, null);
                return this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)source.hasGraph(testGraphName)), new Position("SessionGraphDataSourceTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("SessionGraphDataSourceTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
        this.it().apply("hasGraph should return false for non-existing graph", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionGraphDataSourceTest $outer;

            public final Assertion apply() {
                SessionGraphDataSource source = new SessionGraphDataSource();
                String testGraphName = "test";
                return this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)source.hasGraph(testGraphName)), new Position("SessionGraphDataSourceTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("SessionGraphDataSourceTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
        this.it().apply("graph should return graph for existing graph", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionGraphDataSourceTest $outer;

            public final Assertion apply() {
                SessionGraphDataSource source = new SessionGraphDataSource();
                String testGraphName = "test";
                PropertyGraph testGraph = (PropertyGraph)this.$outer.mock(ClassTag$.MODULE$.apply(PropertyGraph.class));
                source.store(testGraphName, testGraph);
                return this.$outer.convertToAnyShouldWrapper(source.graph(testGraphName), new Position("SessionGraphDataSourceTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55), Prettifier$.MODULE$.default()).should(this.$outer.be().apply((Object)testGraph));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("SessionGraphDataSourceTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
        this.it().apply("graph should throw exception for non-existing graph", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionGraphDataSourceTest $outer;

            public final Assertion apply() {
                SessionGraphDataSource source = new SessionGraphDataSource();
                String testGraphName = "test";
                return this.$outer.an(ClassTag$.MODULE$.apply(GraphNotFoundException.class)).should(this.$outer.be(), Prettifier$.MODULE$.default(), new Position("SessionGraphDataSourceTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61)).thrownBy((Function0)new Serializable(this, source, testGraphName){
                    public static final long serialVersionUID = 0L;
                    private final SessionGraphDataSource source$1;
                    private final String testGraphName$1;

                    public final PropertyGraph apply() {
                        return this.source$1.graph(this.testGraphName$1);
                    }
                    {
                        this.source$1 = source$1;
                        this.testGraphName$1 = testGraphName$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("SessionGraphDataSourceTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        this.it().apply("schema should throw for non-existing graph", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionGraphDataSourceTest $outer;

            public final Assertion apply() {
                SessionGraphDataSource source = new SessionGraphDataSource();
                String testGraphName = "test";
                return this.$outer.a(ClassTag$.MODULE$.apply(GraphNotFoundException.class)).shouldBe(this.$outer.thrownBy((Function0<Object>)new Serializable(this, source, testGraphName){
                    public static final long serialVersionUID = 0L;
                    private final SessionGraphDataSource source$2;
                    private final String testGraphName$2;

                    public final Option<Schema> apply() {
                        return this.source$2.schema(this.testGraphName$2);
                    }
                    {
                        this.source$2 = source$2;
                        this.testGraphName$2 = testGraphName$2;
                    }
                }), Prettifier$.MODULE$.default(), new Position("SessionGraphDataSourceTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("SessionGraphDataSourceTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        this.it().apply("schema should return schema for existing graph", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionGraphDataSourceTest $outer;

            public final Assertion apply() {
                SessionGraphDataSource source = new SessionGraphDataSource();
                String testGraphName = "test";
                PropertyGraph propertyGraph = (PropertyGraph)this.$outer.mock(ClassTag$.MODULE$.apply(PropertyGraph.class));
                Mockito.when((Object)propertyGraph.schema()).thenReturn((Object)Schema$.MODULE$.empty().withRelationshipType("foo"));
                source.store(testGraphName, propertyGraph);
                return this.$outer.convertToAnyShouldWrapper(source.schema(testGraphName).get(), new Position("SessionGraphDataSourceTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76), Prettifier$.MODULE$.default()).should(this.$outer.be().apply((Object)Schema$.MODULE$.empty().withRelationshipType("foo")));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("SessionGraphDataSourceTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        this.it().apply("graphNames should return all names of stored graphs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionGraphDataSourceTest $outer;

            public final Assertion apply() {
                SessionGraphDataSource source = new SessionGraphDataSource();
                String testGraphName1 = "test1";
                String testGraphName2 = "test2";
                this.$outer.convertToAnyShouldWrapper(source.graphNames(), new Position("SessionGraphDataSourceTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84), Prettifier$.MODULE$.default()).should(this.$outer.equal(Predef$.MODULE$.Set().empty()), (Object)Equality$.MODULE$.default());
                source.store(testGraphName1, null);
                source.store(testGraphName2, null);
                return this.$outer.convertToAnyShouldWrapper(source.graphNames(), new Position("SessionGraphDataSourceTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88), Prettifier$.MODULE$.default()).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new GraphName[]{new GraphName(testGraphName1), new GraphName(testGraphName2)}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("SessionGraphDataSourceTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
    }
}

