/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.okapi.tck.test.support.creation.neo4j;

import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.harness.ServerControls;
import org.neo4j.harness.TestServerBuilders;
import org.opencypher.okapi.api.value.CypherValue;
import org.opencypher.okapi.tck.test.support.creation.neo4j.Neo4JGraphFactory$;
import org.opencypher.okapi.testing.propertygraph.InMemoryTestGraph;
import org.opencypher.okapi.testing.propertygraph.InMemoryTestNode;
import org.opencypher.okapi.testing.propertygraph.InMemoryTestRelationship;
import scala.Function1;
import scala.Serializable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001E<Q!\u0001\u0002\t\u0002M\t\u0011CT3pi);%/\u00199i\r\u0006\u001cGo\u001c:z\u0015\t\u0019A!A\u0003oK>$$N\u0003\u0002\u0006\r\u0005A1M]3bi&|gN\u0003\u0002\b\u0011\u000591/\u001e9q_J$(BA\u0005\u000b\u0003\u0011!Xm\u001d;\u000b\u0005-a\u0011a\u0001;dW*\u0011QBD\u0001\u0006_.\f\u0007/\u001b\u0006\u0003\u001fA\t!b\u001c9f]\u000eL\b\u000f[3s\u0015\u0005\t\u0012aA8sO\u000e\u0001\u0001C\u0001\u000b\u0016\u001b\u0005\u0011a!\u0002\f\u0003\u0011\u00039\"!\u0005(f_RRuI]1qQ\u001a\u000b7\r^8ssN\u0019Q\u0003\u0007\u0010\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\r\u0005s\u0017PU3g!\tyB%D\u0001!\u0015\t\t#%A\u0007qe>\u0004XM\u001d;zOJ\f\u0007\u000f\u001b\u0006\u0003G1\tq\u0001^3ti&tw-\u0003\u0002&A\t!\u0012J\\'f[>\u0014\u0018p\u0012:ba\"4\u0015m\u0019;pefDQaJ\u000b\u0005\u0002!\na\u0001P5oSRtD#A\n\t\u0011)*\u0002R1A\u0005\u0002-\nqAZ1di>\u0014\u00180F\u0001-!\t!RF\u0002\u0003\u0017\u0005\u0001q3CA\u0017\u0019\u0011\u00159S\u0006\"\u00011)\u0005a\u0003b\u0002\u001a.\u0005\u0004%IaM\u0001\f]\u0016|GG[*feZ,'/F\u00015!\t)\u0014(D\u00017\u0015\t9\u0004(A\u0004iCJtWm]:\u000b\u0005\r\u0001\u0012B\u0001\u001e7\u00059\u0019VM\u001d<fe\u000e{g\u000e\u001e:pYNDa\u0001P\u0017!\u0002\u0013!\u0014\u0001\u00048f_RR7+\u001a:wKJ\u0004\u0003b\u0002 .\u0005\u0004%\taP\u0001\u000bS:\u0004X\u000f^$sCBDW#\u0001!\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\rC\u0014aB4sCBDGMY\u0005\u0003\u000b\n\u0013Ac\u0012:ba\"$\u0015\r^1cCN,7+\u001a:wS\u000e,\u0007BB$.A\u0003%\u0001)A\u0006j]B,Ho\u0012:ba\"\u0004\u0003\"B%.\t\u0003Q\u0015AB2sK\u0006$X\rF\u0002L\u001d^\u0003\"a\b'\n\u00055\u0003#!E%o\u001b\u0016lwN]=UKN$xI]1qQ\")q\n\u0013a\u0001!\u0006Y1M]3bi\u0016\fV/\u001a:z!\t\tFK\u0004\u0002\u001a%&\u00111KG\u0001\u0007!J,G-\u001a4\n\u0005U3&AB*ue&twM\u0003\u0002T5!)\u0001\f\u0013a\u00013\u0006Q\u0001/\u0019:b[\u0016$XM]:\u0011\ti{\u0006+Y\u0007\u00027*\u0011A,X\u0001\nS6lW\u000f^1cY\u0016T!A\u0018\u000e\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002a7\n\u0019Q*\u00199\u0011\u0005e\u0011\u0017BA2\u001b\u0005\r\te.\u001f\u0005\u0006K6\"IAZ\u0001\u0011O\u0016$\bK]8qKJ$\u0018p\u0012:ba\",\u0012a\u0013\u0005\u0006Q6\"\t![\u0001\u0006G2|7/Z\u000b\u0002C\"A1.\u0006E\u0001B\u0003&A&\u0001\u0005gC\u000e$xN]=!\u0011\u0015iW\u0003\"\u0001o\u0003\u0015\t\u0007\u000f\u001d7z)\rYu\u000e\u001d\u0005\u0006\u001f2\u0004\r\u0001\u0015\u0005\u000612\u0004\r!\u0017")
public class Neo4JGraphFactory {
    private final ServerControls neo4jServer = TestServerBuilders.newInProcessBuilder().withConfig("dbms.security.auth_enabled", "true").newServer();
    private final GraphDatabaseService inputGraph = this.neo4jServer().graph();

    public static InMemoryTestGraph apply(String string, Map<String, Object> map) {
        return Neo4JGraphFactory$.MODULE$.apply(string, map);
    }

    public static Neo4JGraphFactory factory() {
        return Neo4JGraphFactory$.MODULE$.factory();
    }

    private ServerControls neo4jServer() {
        return this.neo4jServer;
    }

    public GraphDatabaseService inputGraph() {
        return this.inputGraph;
    }

    public InMemoryTestGraph create(String createQuery, Map<String, Object> parameters) {
        Transaction tx = this.inputGraph().beginTx();
        this.inputGraph().execute("MATCH (a) DETACH DELETE a");
        this.inputGraph().execute(createQuery);
        InMemoryTestGraph propertyGraph = this.getPropertyGraph();
        tx.success();
        tx.close();
        return propertyGraph;
    }

    private InMemoryTestGraph getPropertyGraph() {
        List neoNodes = this.inputGraph().getAllNodes().iterator().stream().collect(Collectors.toList());
        Buffer nodes = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(neoNodes).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final InMemoryTestNode apply(Node neoNode) {
                Set labels = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(neoNode.getLabels()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Label x$1) {
                        return x$1.name();
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toSet();
                long id = neoNode.getId();
                Map properties = CypherValue.CypherMap$.MODULE$.apply(((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(neoNode.getAllProperties()).asScala()).toSeq());
                return new InMemoryTestNode(id, labels, properties);
            }
        }, Buffer$.MODULE$.canBuildFrom());
        List neoRels = this.inputGraph().getAllRelationships().iterator().stream().collect(Collectors.toList());
        Buffer relationships = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(neoRels).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final InMemoryTestRelationship apply(Relationship neoRel) {
                String relType = neoRel.getType().name();
                long sourceId = neoRel.getStartNodeId();
                long targetId = neoRel.getEndNodeId();
                long id = neoRel.getId();
                Map properties = CypherValue.CypherMap$.MODULE$.apply(((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(neoRel.getAllProperties()).asScala()).toSeq());
                return new InMemoryTestRelationship(id, sourceId, targetId, relType, properties);
            }
        }, Buffer$.MODULE$.canBuildFrom());
        return new InMemoryTestGraph((Seq)nodes, (Seq)relationships);
    }

    public Object close() {
        this.neo4jServer().close();
        return BoxedUnit.UNIT;
    }
}

